/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static final KeyBinding keybindKnowledge = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "Corail Tombstone");
    private boolean isGhostlyRender = false;
    private boolean hasTrueSight = false;
    private boolean isFirstGuiGameOver = false;
    private boolean requireRemovalNightVision = false;
    private boolean requireRemovalVisibility = false;
    public static boolean delayedGui;
    private static long nextGhostTime;
    private static final List<Aura> AURAS;
    private static final ResourceLocation[] AURA_TEXTURES;

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderCreatureEvent(RenderLivingEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.hasTrueSight && EntityHelper.isValidPlayer((EntityPlayer)mc.field_71439_g) && event.getEntity().func_98034_c((EntityPlayer)mc.field_71439_g)) {
            event.getEntity().func_82142_c(false);
            this.requireRemovalVisibility = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderCreatureEvent(RenderLivingEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            this.requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.side.isServer()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (EntityHelper.isValidPlayer((EntityPlayer)player)) {
            if (event.phase == TickEvent.Phase.START) {
                boolean bl = this.hasTrueSight = EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.true_sight);
                if (this.hasTrueSight && !EffectHelper.isPotionActive((EntityLivingBase)player, MobEffects.field_76439_r)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 1200, 0, true, false));
                    this.requireRemovalNightVision = true;
                }
            } else if (this.requireRemovalNightVision) {
                player.func_184596_c(MobEffects.field_76439_r);
                this.requireRemovalNightVision = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && EntityHelper.isValidPlayer((EntityPlayer)mc.field_71439_g)) {
            ITBCapability cap;
            if ((keybindKnowledge.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat) && (cap = (ITBCapability)mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null) {
                delayedGui = false;
                mc.func_147108_a((GuiScreen)new GuiKnowledge(cap));
            }
            if (ConfigTombstone.client.enableHalloweenEffect && Helper.isDateAroundHalloween(event.player.field_70170_p)) {
                if (Helper.isNight(event.player.field_70170_p)) {
                    long time = event.player.field_70170_p.func_82737_E();
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && EntityHelper.canPray(event.player)) {
                            BlockPos pos = event.player.func_180425_c().func_177982_a(Helper.getRandom(-9, 9), 0, Helper.getRandom(-9, 9));
                            mc.field_71452_i.func_78873_a((Particle)new ParticleGhost(event.player.field_70170_p, pos));
                            event.player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(event.player.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                            mc.field_71441_e.func_184156_a(pos, SoundHandler.getSound(Helper.getRandom(0, 3) == 0 ? "ghost_laugh" : "ghost_howl"), SoundCategory.VOICE, 1.0f, 1.0f, true);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpened(GuiOpenEvent event) {
        EntityPlayerSP player;
        if (event.getGui() instanceof GuiGameOver && ConfigTombstone.client.skipRespawnScreen && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            this.isFirstGuiGameOver = !this.isFirstGuiGameOver;
            event.setCanceled(true);
            if (!this.isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (this.hasTrueSight && event.getState().func_185904_a() == Material.field_151586_h) {
            event.setCanceled(true);
            event.setDensity(event.getDensity() / 4.0f);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (this.hasTrueSight && event.getState().func_185904_a() == Material.field_151586_h) {
            event.setRed(0.09019608f);
            event.setGreen(0.41568628f);
            event.setBlue(0.9254902f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (this.hasTrueSight && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (this.requireRemovalNightVision) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(MobEffects.field_76439_r);
            this.requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null && ConfigTombstone.client.showInfoOnEnchantment && SupportMods.canDisplayTooltipOnEnchant() && event.getItemStack().func_77973_b() == Items.field_151134_bR && event.getItemStack().func_77942_o()) {
            Helper.getTombstoneEnchantments(event.getItemStack()).forEach(enchant -> IntStream.range(0, event.getToolTip().size()).filter(line -> ((String)event.getToolTip().get(line)).startsWith(LangKey.makeClientTranslation(enchant.func_77320_a(), new Object[0]))).findFirst().ifPresent(line -> {
                List<String> infos = ((TombstoneEnchantment)((Object)enchant)).getTooltipInfos(event.getItemStack());
                for (String info : infos) {
                    event.getToolTip().add(++line, info);
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void forceOpenTBGuiEvent(CommandEvent event) {
        if (event.isCanceled() && event.getCommand().func_71517_b().equals("tbgui")) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        boolean bl = this.isGhostlyRender = EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangiblenessActive((EntityLivingBase)player);
        if (this.isGhostlyRender) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (this.isGhostlyRender) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        Location location;
        if (!ConfigTombstone.client.highlight) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.func_77973_b() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getStructurePos(stack);
        } else {
            return;
        }
        if (location.isOrigin() || location.dim != player.field_70170_p.field_73011_w.getDimension() || !player.field_70170_p.func_175701_a(location.getPos())) {
            return;
        }
        ClientEventHandler.createBox(location.x, location.y, location.z, 1.0);
    }

    private static void createBox(double x, double y, double z, double offset) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        Vec3d location = new Vec3d(x, y, z).func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        if (location.func_72438_d(Vec3d.field_186680_a) > 200.0) {
            location = location.func_72432_b().func_186678_a(200.0);
        }
        x = location.field_72450_a;
        y = location.field_72448_b;
        z = location.field_72449_c;
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        RenderGlobal.func_189694_a((double)x, (double)y, (double)z, (double)(x + offset), (double)(y + offset), (double)(z + offset), (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void setAuraToRender(RenderLivingEvent.Pre event) {
        AuraType auraType;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && ConfigTombstone.client.showMagicCircle && !event.getEntity().func_98034_c((EntityPlayer)mc.field_71439_g) && (auraType = AuraType.getAuraType(event.getEntity())) != null) {
            Aura aura = new Aura(event.getEntity(), auraType);
            double opaque = 1.0;
            double distanceToCamera = mc.func_175598_ae().func_78714_a(((Aura)aura).position.field_72450_a, ((Aura)aura).position.field_72448_b, ((Aura)aura).position.field_72449_c);
            double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
            if (f > 0.0) {
                AURAS.add(aura);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderAuras(RenderWorldLastEvent event) {
        AuraType auraType;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O == 0 && mc.field_71439_g != null && ConfigTombstone.client.showMagicCircle && (auraType = AuraType.getAuraType((EntityLivingBase)mc.field_71439_g)) != null) {
            Aura aura2 = new Aura((EntityLivingBase)mc.field_71439_g, auraType);
            double opaque = 1.0;
            double distanceToCamera = mc.func_175598_ae().func_78714_a(((Aura)aura2).position.field_72450_a, ((Aura)aura2).position.field_72448_b, ((Aura)aura2).position.field_72449_c);
            double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
            if (f > 0.0) {
                AURAS.add(aura2);
            }
        }
        if (!AURAS.isEmpty()) {
            double ratio = (double)System.currentTimeMillis() * 0.03 % 360.0;
            AURAS.forEach(aura -> this.renderAura(mc, (Aura)aura, ratio));
            AURAS.clear();
        }
    }

    private static boolean hasAura(EntityLivingBase entity) {
        ItemStack heldStack;
        return entity.func_184587_cr() && (ModItems.tablet_of_recall.isAncient(heldStack = entity.func_184614_ca()) || heldStack.func_77973_b() == ModItems.ankh_of_pray);
    }

    private void renderAura(Minecraft mc, Aura aura, double ratio) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.Profile.PLAYER_SKIN.func_187373_a();
        GlStateManager.func_179129_p();
        mc.func_110434_K().func_110577_a(AURA_TEXTURES[0]);
        Vec3d vec3 = aura.position.func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        GlStateManager.func_179137_b((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
        GlStateManager.func_179114_b((float)((float)ratio), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-vec3.field_72450_a), (double)(-vec3.field_72448_b), (double)(-vec3.field_72449_c));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Vec3d vec1 = new Vec3d(vec3.field_72450_a - aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c - aura.auraType.radius);
        Vec3d vec2 = new Vec3d(vec3.field_72450_a + aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c + aura.auraType.radius);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.Profile.PLAYER_SKIN.func_187374_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)keybindKnowledge);
        delayedGui = false;
        nextGhostTime = -1L;
        AURAS = new ArrayList<Aura>();
        AURA_TEXTURES = new ResourceLocation[]{new ResourceLocation("tombstone", "textures/aura/aura1.png")};
    }

    private static class Aura {
        private final Vec3d position;
        private final AuraType auraType;

        private Aura(EntityLivingBase entity, AuraType auraType) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            this.position = new Vec3d(Helper.lerp(partialTicks, entity.field_70142_S, entity.field_70165_t), Helper.lerp(partialTicks, entity.field_70137_T, entity.field_70163_u), Helper.lerp(partialTicks, entity.field_70136_U, entity.field_70161_v));
            this.auraType = auraType;
        }

        private Aura(double x, double y, double z) {
            this.position = new Vec3d(x, y, z);
            this.auraType = AuraType.MARKER;
        }
    }

    static enum AuraType {
        PRAY(3.5, 0.88f, 0.78f, 0.48f, 1.0f),
        SCROLL(0.8, 0.38f, 0.28f, 0.88f, 1.0f),
        SIMPLE_TELEPORT(0.8, 0.23f, 0.78f, 0.86f, 1.0f),
        AREA_TELEPORT(5.0, 0.23f, 0.78f, 0.86f, 1.0f),
        MARKER(1.0, 0.38f, 0.48f, 0.18f, 1.0f);

        private final double radius;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        private AuraType(double radius, float r, float g, float b, float a) {
            this.radius = radius;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static AuraType getAuraType(EntityLivingBase entity) {
            if (!entity.func_184587_cr()) {
                return null;
            }
            ItemStack heldStack = entity.func_184614_ca();
            Item heldItem = heldStack.func_77973_b();
            if (heldItem == ModItems.ankh_of_pray) {
                return PRAY;
            }
            if (heldItem == ModItems.grave_key || heldItem == ModItems.lost_tablet || heldItem == ModItems.tablet_of_assistance) {
                return SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.tablet_of_recall || heldItem == ModItems.tablet_of_home) {
                return ((ItemGraveMagic)heldStack.func_77973_b()).isAncient(heldStack) ? AREA_TELEPORT : SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.scroll_buff || heldItem == ModItems.scroll_of_knowledge) {
                return SCROLL;
            }
            return null;
        }
    }
}

