/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModItems;

@JEIPlugin
public class IntegrationJEI
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IIngredientBlacklist blackList = jeiHelpers.getIngredientBlacklist();
        blackList.addIngredientToBlacklist((Object)new ItemStack(ModItems.advancement));
        blackList.addIngredientToBlacklist((Object)new ItemStack(ModItems.lollypop));
        IVanillaRecipeFactory recipeFactory = jeiHelpers.getVanillaRecipeFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        ItemStack gravePlate = new ItemStack((Item)ModItems.grave_plate);
        builder.add((Object)recipeFactory.createAnvilRecipe(gravePlate, Collections.singletonList(new ItemStack(Items.field_151042_j)), Collections.singletonList(EngravableHelper.setEngravedName(gravePlate.func_77946_l(), Helper.THANK_NAMES.get(Helper.random.nextInt(Helper.THANK_NAMES.size()))))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((Item)ModItems.tablet_of_assistance), "enchant", true);
        builder.add((Object)recipeFactory.createAnvilRecipe(tablet, Collections.singletonList(ItemCraftingIngredient.IconType.GRAVE_DUST.getStack()), Collections.singletonList(EngravableHelper.setEngravedName(tablet.func_77946_l(), Helper.THANK_NAMES.get(Helper.random.nextInt(Helper.THANK_NAMES.size()))))));
        registry.addRecipes((Collection)builder.build(), "minecraft.anvil");
    }

    public void registerItemSubtypes(ISubtypeRegistry registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_home, (ISubtypeRegistry.ISubtypeInterpreter)new AncientTabletInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_recall, (ISubtypeRegistry.ISubtypeInterpreter)new AncientTabletInterpreter());
    }

    private static class AncientTabletInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private AncientTabletInterpreter() {
        }

        @Nonnull
        public String apply(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() == ModItems.tablet_of_home || stack.func_77973_b() == ModItems.tablet_of_recall) {
                return String.valueOf(((ItemTablet)stack.func_77973_b()).isAncient(stack));
            }
            return "0";
        }
    }
}

