/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.stream.Stream;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.VillageSiegeHandler;

public class CommandTBSiege
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbsiege";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer world;
        if (args.length > 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!ConfigTombstone.village_siege.handleVillageSiege) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_DISABLED.getKey(), new Object[0]);
        }
        if (args.length == 0) {
            world = (WorldServer)sender.func_130014_f_();
        } else {
            int dim = CommandTBSiege.func_175755_a((String)args[0]);
            if (Helper.isValidDimension(dim)) {
                world = DimensionManager.getWorld((int)dim);
                if (world == null) {
                    throw new CommandException(LangKey.COMMAND_EXCEPTION_UNLOADED_DIMENSION.getKey(), new Object[0]);
                }
            } else {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
            }
        }
        if (world.func_72912_H().func_176130_y() == EnumDifficulty.PEACEFUL) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_DIFFICULTY_PEACEFUL.getKey(), new Object[0]);
        }
        if (Stream.of(ConfigTombstone.village_siege.deniedDimensionTypeForSiege).anyMatch(p -> p.equals(world.field_73011_w.func_186058_p().func_186065_b()))) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_DENIED_DIMENSION.getKey(), new Object[0]);
        }
        if (world.func_72935_r()) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_ONLY_AT_NIGHT.getKey(), new Object[0]);
        }
        if (world.field_175740_d instanceof VillageSiegeHandler.CustomVillageSiege) {
            VillageSiegeHandler.CustomVillageSiege villageSiege = (VillageSiegeHandler.CustomVillageSiege)world.field_175740_d;
            switch (villageSiege.field_75536_c) {
                case SIEGE_START: 
                case SPAWN_MOBS: {
                    throw new CommandException(LangKey.MESSAGE_START_SIEGE_FAILED.getKey(), new Object[0]);
                }
                case INIT: 
                case SIEGE_END: 
                case DAY_TIME: {
                    LangKey.MESSAGE_START_SIEGE_SUCCESS.sendMessage(sender, new Object[0]);
                    villageSiege.hasFailedTrySiege = false;
                    villageSiege.field_75536_c = VillageSiegeHandler.SiegeState.SIEGE_START;
                }
            }
        }
    }
}

