/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.template;

import com.mushroom.midnight.common.world.template.TemplateDataProcessor;
import com.mushroom.midnight.common.world.template.TemplatePostProcessor;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class CompiledTemplate {
    private final ResourceLocation templateId;
    private final Template template;
    private final PlacementSettings settings;
    private final BlockPos origin;
    private final ITemplateProcessor processor;
    private final TemplateDataProcessor dataProcessor;
    private final Collection<TemplatePostProcessor> postProcessors;
    private final Map<BlockPos, String> dataBlocks;

    CompiledTemplate(ResourceLocation templateId, Template template, PlacementSettings settings, BlockPos origin, ITemplateProcessor processor, TemplateDataProcessor dataProcessor, Collection<TemplatePostProcessor> postProcessors) {
        this.templateId = templateId;
        this.template = template;
        this.settings = settings;
        this.origin = origin;
        this.processor = processor != null ? processor : new BlockRotationProcessor(origin, settings);
        this.dataProcessor = dataProcessor;
        this.postProcessors = postProcessors;
        this.dataBlocks = this.template.func_186258_a(origin, settings);
    }

    public void addTo(World world, Random random, int flags) {
        this.template.func_189960_a(world, this.origin, this.processor, this.settings, flags);
        if (this.dataProcessor != null) {
            for (Map.Entry entry : this.dataBlocks.entrySet()) {
                this.dataProcessor.process(world, (BlockPos)entry.getKey(), (String)entry.getValue());
            }
        }
        for (TemplatePostProcessor templatePostProcessor : this.postProcessors) {
            for (Template.BlockInfo info : this.template.field_186270_a) {
                BlockPos pos = Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)info.field_186242_a).func_177971_a((Vec3i)this.origin);
                Template.BlockInfo processedInfo = this.processor.func_189943_a(world, pos, info);
                if (processedInfo == null) continue;
                templatePostProcessor.process(world, random, pos, processedInfo.field_186243_b);
            }
        }
    }

    @Nullable
    public BlockPos lookupAny(String key) {
        return this.lookupStream(key).findFirst().orElse(null);
    }

    public Collection<BlockPos> lookup(String key) {
        return this.lookupStream(key).collect(Collectors.toList());
    }

    public Stream<BlockPos> lookupStream(String key) {
        return this.dataBlocks.entrySet().stream().filter(e -> ((String)e.getValue()).equals(key)).map(Map.Entry::getKey);
    }

    public String toString() {
        return "CompiledTemplate{template=" + this.templateId + ", origin=" + this.origin + '}';
    }
}

