/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityGrowable
extends EntityCreature {
    private static final DataParameter<Integer> GROWING_AGE = EntityDataManager.func_187226_a(EntityGrowable.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int growingTime = 0;
    private float ageWidth = -1.0f;
    private float ageHeight;

    public EntityGrowable(World world) {
        super(world);
    }

    public abstract int getMaxGrowingAge();

    public abstract int getGrowingTimeByAge();

    protected abstract void onGrowingToAge(int var1);

    @Nullable
    public abstract EntityGrowable createChild(EntityGrowable var1);

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWING_AGE, (Object)0);
    }

    public int getGrowingAge() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(GROWING_AGE, (Object)age);
        this.growingTime = 0;
        this.onGrowingToAge(age);
        this.setScaleForAge(age);
    }

    public void setScaleForAge(int age) {
        float scale = 1.0f + (float)age * 0.5f;
        super.func_70105_a(this.ageWidth * scale, this.ageHeight * scale);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("growing_age", this.getGrowingAge());
        compound.func_74768_a("growing_time", this.growingTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("growing_age", 3)) {
            this.setGrowingAge(compound.func_74762_e("growing_age"));
        }
        if (compound.func_150297_b("growing_time", 3)) {
            this.growingTime = compound.func_74762_e("growing_time");
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GROWING_AGE.equals(key)) {
            this.setScaleForAge(this.getGrowingAge());
        }
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        super.func_70636_d();
        int growingAge = this.getGrowingAge();
        if (growingAge < this.getMaxGrowingAge() && ++this.growingTime >= this.getGrowingTimeByAge()) {
            this.setGrowingAge(++growingAge);
            this.growingTime -= this.getGrowingTimeByAge();
        }
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.ageWidth > 0.0f;
        this.ageWidth = width;
        this.ageHeight = height;
        if (!flag) {
            super.func_70105_a(this.ageWidth, this.ageHeight);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            EntityGrowable entity;
            if (!this.field_70170_p.field_72995_K && this.holdingSpawnEggOfClass(stack, ((Object)((Object)this)).getClass()) && (entity = this.createChild(this)) != null) {
                entity.setGrowingAge(-1);
                entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entity);
                if (stack.func_82837_s()) {
                    entity.func_96094_a(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    private boolean holdingSpawnEggOfClass(ItemStack stack, Class<? extends Entity> entityClass) {
        if (stack.func_77973_b() != Items.field_151063_bx) {
            return false;
        }
        ResourceLocation rl = ItemMonsterPlacer.func_190908_h((ItemStack)stack);
        if (rl != null) {
            Class oclass = EntityList.getClass((ResourceLocation)rl);
            return entityClass == oclass;
        }
        return false;
    }
}

