/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.surface;

import com.mushroom.midnight.common.biome.EntitySpawnConfigured;
import com.mushroom.midnight.common.biome.config.SpawnerConfig;
import com.mushroom.midnight.common.biome.config.SurfaceConfig;
import com.mushroom.midnight.common.biome.surface.SurfaceBiomeConfig;
import com.mushroom.midnight.common.biome.surface.SurfaceTerrainConfig;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.world.SurfaceCoverGenerator;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SurfaceBiome
extends Biome
implements EntitySpawnConfigured {
    protected final SurfaceBiomeConfig config;
    private final SurfaceConfig localSurfaceConfig;
    private final SurfaceCoverGenerator coverGenerator = new SurfaceCoverGenerator(0, 0);

    public SurfaceBiome(String name, SurfaceBiomeConfig config) {
        super(config.buildProperties(name));
        this.config = config;
        this.localSurfaceConfig = new SurfaceConfig(this.config.getSurfaceConfig());
        this.field_76760_I = config.getFeatureConfig().createDecorator(PlacementLevel.INSTANCE);
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            this.func_76747_a(creatureType).clear();
        }
        config.getSurfaceConfig().apply(this);
        this.flowers.clear();
    }

    public SurfaceBiomeConfig getConfig() {
        return this.config;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_185359_l() {
        return I18n.func_135052_a((String)("biome.midnight." + super.func_185359_l() + ".name"), (Object[])new Object[0]);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int z, int x, double noiseVal) {
        this.configureSurface(this.localSurfaceConfig, this.config.getSurfaceConfig(), x, z, rand);
        int fillerDepth = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        this.coverGenerator.coverSurface(this.localSurfaceConfig, primer, x, z, fillerDepth);
    }

    protected SurfaceConfig configureSurface(SurfaceConfig config, SurfaceConfig parent, int x, int z, Random random) {
        return config;
    }

    public void addFlower(IBlockState state, int weight) {
        if (MidnightConfig.general.foreignFlowersFromBonemeal) {
            super.addFlower(state, weight);
        }
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(this.config.getGrassColor());
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(this.config.getFoliageColor());
    }

    public static SurfaceTerrainConfig getTerrainConfig(Biome biome) {
        if (biome instanceof SurfaceBiome) {
            return ((SurfaceBiome)biome).getConfig().getTerrainConfig();
        }
        return SurfaceTerrainConfig.DEFAULT;
    }

    @Override
    public SpawnerConfig getSpawnerConfig() {
        return this.config.getSpawnerConfig();
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
        Biome.FlowerEntry flower;
        List<Object> flowerList = MidnightConfig.general.foreignFlowersFromBonemeal && !this.flowers.isEmpty() ? Stream.concat(this.flowers.stream(), this.config.getFeatureConfig().getFlowers().stream()).collect(Collectors.toList()) : this.config.getFeatureConfig().getFlowers();
        if (!(flowerList.isEmpty() || (flower = (Biome.FlowerEntry)WeightedRandom.func_76271_a((Random)rand, flowerList)) == null || flower.state == null || flower.state.func_177230_c() instanceof BlockBush && !((BlockBush)flower.state.func_177230_c()).func_180671_f(world, pos, flower.state))) {
            world.func_180501_a(pos, flower.state, 3);
        }
    }

    public static final class PlacementLevel
    implements SurfacePlacementLevel {
        public static SurfacePlacementLevel INSTANCE = new PlacementLevel();

        private PlacementLevel() {
        }

        @Override
        public BlockPos getSurfacePos(World world, BlockPos pos) {
            return world.func_175645_m(pos);
        }

        @Override
        public int generateUpTo(World world, Random random, int y) {
            int bound = Math.max(y - 58, 1);
            return random.nextInt(bound) + 58;
        }
    }
}

