/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.biome.BiomeLayerType;
import com.mushroom.midnight.common.biome.MidnightBiomeGroup;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.registry.ModCavernousBiomes;
import com.mushroom.midnight.common.registry.ModSurfaceBiomes;
import com.mushroom.midnight.common.world.layer.AddOutlineLayer;
import com.mushroom.midnight.common.world.layer.CavernSeedLayer;
import com.mushroom.midnight.common.world.layer.CellSeedLayer;
import com.mushroom.midnight.common.world.layer.CreateGroupPocketsLayer;
import com.mushroom.midnight.common.world.layer.EdgeMergeLayer;
import com.mushroom.midnight.common.world.layer.OutlineProducerLayer;
import com.mushroom.midnight.common.world.layer.RidgeMergeLayer;
import com.mushroom.midnight.common.world.layer.SeedGroupLayer;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;

public final class MidnightBiomeLayer<T>
implements BiomeLayerType<T> {
    public static final MidnightBiomeLayer<Biome> SURFACE = new MidnightBiomeLayer(MidnightBiomeLayer::buildSurfaceProcedure);
    public static final MidnightBiomeLayer<CavernousBiome> UNDERGROUND = new MidnightBiomeLayer(MidnightBiomeLayer::buildUndergroundProcedure);
    private final Supplier<GenLayer> procedureBuilder;

    private MidnightBiomeLayer(Supplier<GenLayer> procedureBuilder) {
        this.procedureBuilder = procedureBuilder;
    }

    public GenLayer buildProcedure() {
        return this.procedureBuilder.get();
    }

    private static GenLayer buildSurfaceProcedure() {
        GenLayer ridgeLayer = MidnightBiomeLayer.buildEdgeHighlightLayer(100L);
        GenLayer valleyLayer = MidnightBiomeLayer.buildEdgeHighlightLayer(200L);
        GenLayer layer = new SeedGroupLayer(0L, MidnightBiomeGroup.SURFACE);
        layer = new GenLayerVoronoiZoom(1000L, layer);
        layer = new CreateGroupPocketsLayer(2000L, layer, MidnightBiomeGroup.SURFACE_POCKET, 9);
        layer = new GenLayerFuzzyZoom(3000L, layer);
        layer = new RidgeMergeLayer(4000L, layer, ridgeLayer);
        layer = GenLayerZoom.func_75915_a((long)5000L, (GenLayer)layer, (int)2);
        int plateauId = Biome.func_185362_a((Biome)ModSurfaceBiomes.OBSCURED_PLATEAU);
        int valleyId = Biome.func_185362_a((Biome)ModSurfaceBiomes.PHANTASMAL_VALLEY);
        layer = new EdgeMergeLayer(6000L, layer, valleyLayer, plateauId, valleyId);
        layer = GenLayerZoom.func_75915_a((long)7000L, (GenLayer)layer, (int)1);
        layer = new GenLayerSmooth(8000L, layer);
        return layer;
    }

    private static GenLayer buildUndergroundProcedure() {
        int closedCavernId = ModCavernousBiomes.getId(ModCavernousBiomes.CLOSED_CAVERN);
        GenLayer passageLayer = MidnightBiomeLayer.buildEdgeHighlightLayer(300L);
        GenLayer layer = new CavernSeedLayer(0L, MidnightBiomeGroup.UNDERGROUND);
        layer = new GenLayerVoronoiZoom(1000L, layer);
        layer = new AddOutlineLayer(2000L, layer, closedCavernId);
        layer = new CreateGroupPocketsLayer(3000L, layer, MidnightBiomeGroup.UNDERGROUND_POCKET, 8);
        layer = new GenLayerFuzzyZoom(4000L, layer);
        layer = GenLayerZoom.func_75915_a((long)5000L, (GenLayer)layer, (int)2);
        int fungalCavernId = ModCavernousBiomes.getId(ModCavernousBiomes.FUNGAL_CAVERN);
        layer = new EdgeMergeLayer(6000L, layer, passageLayer, closedCavernId, fungalCavernId);
        layer = GenLayerZoom.func_75915_a((long)7000L, (GenLayer)layer, (int)1);
        layer = new GenLayerSmooth(8000L, layer);
        return layer;
    }

    private static GenLayer buildEdgeHighlightLayer(long seed) {
        GenLayer valleyLayer = new CellSeedLayer(10L + seed);
        valleyLayer = new GenLayerVoronoiZoom(20L + seed, valleyLayer);
        valleyLayer = GenLayerZoom.func_75915_a((long)(30L + seed), (GenLayer)valleyLayer, (int)2);
        valleyLayer = new OutlineProducerLayer(40L + seed, valleyLayer);
        return valleyLayer;
    }
}

