/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.BiomeLayerSampler;
import com.mushroom.midnight.common.biome.MidnightBiomeLayer;
import com.mushroom.midnight.common.capability.CavernousBiomeStore;
import com.mushroom.midnight.common.capability.MidnightWorldSpawners;
import com.mushroom.midnight.common.capability.MultiLayerBiomeSampler;
import com.mushroom.midnight.common.capability.RiftTravelCooldown;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.event.RifterCaptureEvent;
import com.mushroom.midnight.common.event.RifterReleaseEvent;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModCavernousBiomes;
import com.mushroom.midnight.common.registry.ModDimensions;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.world.GlobalBridgeManager;
import com.mushroom.midnight.common.world.RiftSpawnHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="midnight")
public class CommonEventHandler {
    public static final float SOUND_TRAVEL_DISTANCE_MULTIPLIER = 2.0f;
    private static final ThreadLocal<DimensionType> TICKING_DIMENSION = ThreadLocal.withInitial(() -> null);

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("midnight", "rift_cooldown"), (ICapabilityProvider)new RiftTravelCooldown());
        if (event.getObject() instanceof EntityLivingBase) {
            if (!(event.getObject() instanceof EntityPlayer)) {
                ResourceLocation rl = EntityList.func_191301_a((Entity)((Entity)event.getObject()));
                if (rl == null) {
                    return;
                }
                if (event.getObject() instanceof EntityAnimal ? Arrays.stream(MidnightConfig.general.notCapturableAnimals).anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p)) : !Arrays.asList(MidnightConfig.general.capturableEntities).contains(rl.toString())) {
                    return;
                }
            }
            event.addCapability(new ResourceLocation("midnight", "rifter_captured"), (ICapabilityProvider)new RifterCapturable());
        }
    }

    @SubscribeEvent
    public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        if (Helper.isMidnightDimension(((Chunk)event.getObject()).func_177412_p())) {
            event.addCapability(new ResourceLocation("midnight", "cavernous_biomes"), (ICapabilityProvider)new CavernousBiomeStore());
        }
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (Helper.isMidnightDimension(world)) {
            MultiLayerBiomeSampler sampler = new MultiLayerBiomeSampler();
            GenLayer surfaceProcedure = MidnightBiomeLayer.SURFACE.buildProcedure();
            GenLayer undergroundProcedure = MidnightBiomeLayer.UNDERGROUND.buildProcedure();
            sampler.put(MidnightBiomeLayer.SURFACE, BiomeLayerSampler.fromGenLayer(world, surfaceProcedure, Biome::func_185357_a, false));
            sampler.put(MidnightBiomeLayer.UNDERGROUND, BiomeLayerSampler.fromGenLayer(world, undergroundProcedure, ModCavernousBiomes::fromId, true));
            event.addCapability(new ResourceLocation("midnight", "biome_sampler"), (ICapabilityProvider)sampler);
            if (!world.field_72995_K && world instanceof WorldServer) {
                MidnightWorldSpawners.SurfaceAndCave spawners = new MidnightWorldSpawners.SurfaceAndCave((WorldServer)world);
                event.addCapability(new ResourceLocation("midnight", "world_spawners"), (ICapabilityProvider)spawners);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        GameRules gameRules = event.getWorld().func_82736_K();
        if (!gameRules.func_82765_e("doRiftSpawning")) {
            gameRules.func_180262_a("doRiftSpawning", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        RiftTravelCooldown cooldownCap = (RiftTravelCooldown)entity.getCapability(Midnight.RIFT_TRAVEL_COOLDOWN_CAP, null);
        if (cooldownCap != null) {
            cooldownCap.update((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            World world = event.world;
            if (!world.field_72995_K) {
                MidnightWorldSpawners worldSpawners;
                GlobalBridgeManager.getServer().update();
                if (world.func_82736_K().func_82766_b("doMobSpawning") && (worldSpawners = (MidnightWorldSpawners)world.getCapability(Midnight.WORLD_SPAWNERS_CAP, null)) != null) {
                    worldSpawners.spawnAroundPlayers();
                }
            }
            TICKING_DIMENSION.set(world.field_73011_w.func_186058_p());
        } else {
            TICKING_DIMENSION.set(null);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (MidnightConfig.general.riftSpawnRarity > 0 && event.phase == TickEvent.Phase.END) {
            RiftSpawnHandler.update();
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity trueSource = source.func_76346_g();
        if (trueSource instanceof EntityLivingBase && ((EntityLivingBase)trueSource).func_70644_a(ModEffects.STUNNED)) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onRifterCapture(RifterCaptureEvent event) {
        EntityLivingBase captured = event.getCaptured();
        if (captured instanceof EntityPlayer) {
            ((EntityPlayer)captured).eyeHeight = captured.field_70130_N / 2.0f;
        }
    }

    @SubscribeEvent
    public static void onRifterRelease(RifterReleaseEvent event) {
        EntityLivingBase captured = event.getCaptured();
        if (captured instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)captured;
            player.eyeHeight = player.getDefaultEyeHeight();
        }
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() == null) {
            EntityPlayer player = event.getEntityPlayer();
            BlockPos bedPos = event.getPos();
            List rifts = player.field_70170_p.func_72872_a(EntityRift.class, new AxisAlignedBB(bedPos).func_186662_g(6.0));
            if (!rifts.isEmpty()) {
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("status.midnight.rift_nearby", new Object[0]), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundAtEntityEvent event) {
        if (TICKING_DIMENSION.get() == ModDimensions.MIDNIGHT) {
            event.setVolume(event.getVolume() * 2.0f);
        }
    }
}

