/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSurfacePatch
extends WorldGenerator {
    private final IBlockState surfaceBlockState;
    private final IBlockState replacementBlockState;
    private final int numPatches;
    private final Random randy;

    public WorldGenSurfacePatch(IBlockState generate, IBlockState replace, int numPatches) {
        this.surfaceBlockState = generate;
        this.replacementBlockState = replace;
        this.numPatches = numPatches;
        this.randy = new Random(8008135L);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean[][] previouslyChecked = new boolean[16][16];
        for (int n = 0; n < this.numPatches; ++n) {
            int size = 4 + this.randy.nextInt(5);
            int maxOffset = 16 - size;
            if (maxOffset == 0) {
                maxOffset = 1;
            }
            int xOffset = this.randy.nextInt(maxOffset);
            int zOffset = this.randy.nextInt(maxOffset);
            double midX = (double)size / 2.0 + (double)xOffset;
            double midZ = (double)size / 2.0 + (double)zOffset;
            double maxDist = (double)size / 2.0 * ((double)size / 2.0);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double zWarp;
                    double zDist;
                    double xWarp;
                    double xDist;
                    if (previouslyChecked[z][x] || !((xDist = (midX - (double)x) * (xWarp = this.randy.nextDouble() / 3.0 + 0.833)) * xDist + (zDist = (midZ - (double)z) * (zWarp = this.randy.nextDouble() / 3.0 + 0.833)) * zDist < maxDist - (double)rand.nextInt(3))) continue;
                    previouslyChecked[z][x] = true;
                    BlockPos current = pos.func_177982_a(x, 70, z);
                    while (current.func_177956_o() > 49 && world.func_175623_d(current)) {
                        current = current.func_177977_b();
                    }
                    if (world.func_180495_p(current) != this.replacementBlockState) continue;
                    world.func_180501_a(current, this.surfaceBlockState, 2);
                }
            }
        }
        return true;
    }
}

