/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.biomes;

import fluke.stygian.block.ModBlocks;
import fluke.stygian.config.Configs;
import fluke.stygian.world.biomes.BiomeDecoratorEndBiomes;
import fluke.stygian.world.feature.WorldGenEndPlant;
import fluke.stygian.world.feature.WorldGenEnderCanopy;
import fluke.stygian.world.feature.WorldGenSurfacePatch;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeEndJungle
extends Biome {
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Stygian Growth");
    public WorldGenerator endTallGrass;
    public WorldGenerator endGlowGrass;
    public WorldGenerator endGrassRemoval;
    public WorldGenerator endCanopyTree;
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState END_STONE = Blocks.field_150377_bs.func_176223_P();
    private static final IBlockState END_GRASS = ModBlocks.endGrass.func_176223_P();
    private Random randy;

    public BiomeEndJungle() {
        super(properties);
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 10, 4, 4));
        this.field_76752_A = END_GRASS;
        this.field_76753_B = END_STONE;
        this.field_76760_I = new BiomeEndDecorator();
        this.endGrassRemoval = new WorldGenSurfacePatch(END_STONE, END_GRASS, 1);
        this.endCanopyTree = new WorldGenEnderCanopy(true);
        this.endTallGrass = new WorldGenEndPlant(ModBlocks.endTallGrass.func_176223_P());
        this.endGlowGrass = new WorldGenEndPlant(ModBlocks.endGlowPlant.func_176223_P());
        this.randy = new Random();
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorEndBiomes();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 0;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int yHeight;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int terrainHeight;
                int plantRoll = this.randy.nextInt(100);
                if (plantRoll > 17 || (terrainHeight = this.getEndSurfaceHeight(world, pos.func_177982_a(x + 8, 0, z + 8), 52 - this.randy.nextInt(5), 70)) <= 0) continue;
                BlockPos plantPos = pos.func_177982_a(x + 8, terrainHeight, z + 8);
                if (plantRoll == 17) {
                    this.endGlowGrass.func_180709_b(world, this.randy, plantPos);
                    continue;
                }
                this.endTallGrass.func_180709_b(world, this.randy, plantPos);
            }
        }
        if (this.randy.nextInt(7) != 0) {
            this.endGrassRemoval.func_180709_b(world, rand, pos.func_177982_a(8, 0, 8));
        }
        if (this.randy.nextInt(Configs.worldgen.treeFrequency) == 0 && (yHeight = this.getEndSurfaceHeight(world, pos.func_177982_a(16, 0, 16), 50, 70)) > 0) {
            this.endCanopyTree.func_180709_b(world, rand, pos.func_177982_a(16, yHeight + 1, 16));
        }
        super.func_180624_a(world, rand, pos);
    }

    private int getEndSurfaceHeight(World world, BlockPos pos, int min, int max) {
        int maxY = max;
        int minY = min;
        for (int currentY = maxY; currentY >= minY; --currentY) {
            if (world.func_175623_d(pos.func_177982_a(0, currentY, 0))) continue;
            return currentY;
        }
        return 0;
    }

    static {
        properties.func_185410_a(Biomes.field_76779_k.func_185353_n());
        properties.func_185395_b(Biomes.field_76779_k.func_76727_i());
        properties.func_185396_a();
    }
}

