/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.FoodList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public final class ProgressInfo {
    private static final String NBT_KEY_FOODS_EATEN = "foodsEaten";
    private static final String NBT_KEY_CONFIG_INFO = "configInfo";
    public final int foodsEaten;
    public final ConfigInfo configInfo;

    ProgressInfo(NBTTagCompound tag) {
        this.foodsEaten = tag.func_74762_e(NBT_KEY_FOODS_EATEN);
        this.configInfo = new ConfigInfo(tag.func_74775_l(NBT_KEY_CONFIG_INFO));
    }

    ProgressInfo(FoodList foodList) {
        this.configInfo = new ConfigInfo();
        this.foodsEaten = (int)foodList.getEatenFoods().stream().map(FoodInstance::getItemStack).filter(this.configInfo::shouldCount).count();
    }

    public boolean hasReachedMax() {
        return this.foodsEaten >= this.configInfo.milestones[this.configInfo.milestones.length - 1];
    }

    public int nextMilestone() {
        return this.hasReachedMax() ? -1 : this.configInfo.milestones[this.milestonesAchieved()];
    }

    public int foodsUntilNextMilestone() {
        return this.nextMilestone() - this.foodsEaten;
    }

    public int milestonesAchieved() {
        return (int)Arrays.stream(this.configInfo.milestones).filter(milestone -> this.foodsEaten >= milestone).count();
    }

    NBTTagCompound getNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(NBT_KEY_FOODS_EATEN, this.foodsEaten);
        tag.func_74782_a(NBT_KEY_CONFIG_INFO, (NBTBase)this.configInfo.getTag());
        return tag;
    }

    public static final class ConfigInfo {
        private static final String NBT_KEY_MILESTONES = "milestones";
        private static final String NBT_KEY_HEARTS_PER_MILESTONE = "heartsPerMilestone";
        private static final String NBT_KEY_BASE_HEARTS = "baseHearts";
        private static final String NBT_KEY_SHOULD_SHOW_UNEATEN_FOODS = "shouldShowUneatenFoods";
        private static final String NBT_KEY_MINIMUM_FOOD_VALUE = "minimumFoodValue";
        private static final String NBT_KEY_BLACKLIST = "blacklist";
        private static final String NBT_KEY_WHITELIST = "whitelist";
        public final int[] milestones;
        public final int baseHearts;
        public final int heartsPerMilestone;
        public final boolean shouldShowUneatenFoods;
        public final int minimumFoodValue;
        public final String[] blacklist;
        public final String[] whitelist;

        ConfigInfo(NBTTagCompound tag) {
            this.milestones = tag.func_74759_k(NBT_KEY_MILESTONES);
            this.baseHearts = tag.func_74762_e(NBT_KEY_BASE_HEARTS);
            this.heartsPerMilestone = tag.func_74762_e(NBT_KEY_HEARTS_PER_MILESTONE);
            this.shouldShowUneatenFoods = tag.func_74767_n(NBT_KEY_SHOULD_SHOW_UNEATEN_FOODS);
            this.minimumFoodValue = tag.func_74762_e(NBT_KEY_MINIMUM_FOOD_VALUE);
            this.blacklist = ConfigInfo.decodeList(tag.func_74779_i(NBT_KEY_BLACKLIST));
            this.whitelist = ConfigInfo.decodeList(tag.func_74779_i(NBT_KEY_WHITELIST));
        }

        public ConfigInfo() {
            this.milestones = SOLCarrotConfig.milestones;
            this.baseHearts = SOLCarrotConfig.baseHearts;
            this.heartsPerMilestone = SOLCarrotConfig.heartsPerMilestone;
            this.shouldShowUneatenFoods = SOLCarrotConfig.shouldShowUneatenFoods;
            this.minimumFoodValue = SOLCarrotConfig.minimumFoodValue;
            this.blacklist = SOLCarrotConfig.foodBlacklist;
            this.whitelist = SOLCarrotConfig.foodWhitelist;
        }

        NBTTagCompound getTag() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a(NBT_KEY_MILESTONES, this.milestones);
            tag.func_74768_a(NBT_KEY_BASE_HEARTS, this.baseHearts);
            tag.func_74768_a(NBT_KEY_HEARTS_PER_MILESTONE, this.heartsPerMilestone);
            tag.func_74757_a(NBT_KEY_SHOULD_SHOW_UNEATEN_FOODS, this.shouldShowUneatenFoods);
            tag.func_74768_a(NBT_KEY_MINIMUM_FOOD_VALUE, this.minimumFoodValue);
            tag.func_74778_a(NBT_KEY_BLACKLIST, ConfigInfo.encodeList(this.blacklist));
            tag.func_74778_a(NBT_KEY_WHITELIST, ConfigInfo.encodeList(this.whitelist));
            return tag;
        }

        private static String encodeList(String[] list) {
            StringBuilder encoder = new StringBuilder();
            for (String element : list) {
                encoder.append(element);
                encoder.append('|');
            }
            return encoder.toString();
        }

        private static String[] decodeList(String raw) {
            return (String[])Stream.of(raw.split("\\|")).filter(entry -> !entry.isEmpty()).toArray(String[]::new);
        }

        public boolean hasWhitelist() {
            return this.whitelist.length > 0;
        }

        public boolean isAllowed(ItemStack food) {
            String id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)food.func_77973_b())).toString();
            String withMeta = id + ":" + food.func_77960_j();
            if (this.hasWhitelist()) {
                return ConfigInfo.matchesAnyPattern(id, this.whitelist) || ConfigInfo.matchesAnyPattern(withMeta, this.whitelist);
            }
            return !ConfigInfo.matchesAnyPattern(id, this.blacklist) && !ConfigInfo.matchesAnyPattern(withMeta, this.blacklist);
        }

        public boolean shouldCount(ItemStack food) {
            return this.isHearty(food) && this.isAllowed(food);
        }

        public boolean isHearty(ItemStack food) {
            FoodValues foodValues = AppleCoreAPI.accessor.getFoodValues(food);
            if (foodValues == null) {
                return false;
            }
            return foodValues.hunger >= this.minimumFoodValue;
        }

        private static boolean matchesAnyPattern(String query, String[] patterns) {
            for (String glob : patterns) {
                StringBuilder pattern = new StringBuilder(glob.length());
                for (String part : glob.split("\\*", -1)) {
                    if (!part.isEmpty()) {
                        pattern.append(Pattern.quote(part));
                    }
                    pattern.append(".*");
                }
                pattern.delete(pattern.length() - 2, pattern.length());
                if (!Pattern.matches(pattern.toString(), query)) continue;
                return true;
            }
            return false;
        }
    }
}

