/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.init.ModItems;
import com.github.mnesikos.simplycats.item.ItemBase;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPetCarrier
extends ItemBase {
    public ItemPetCarrier() {
        super("pet_carrier");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    public void registerItemModel() {
        for (int i = 0; i < 5; ++i) {
            SimplyCats.PROXY.registerItemRenderer(this, i, this.name);
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if ((target instanceof EntityCat || target instanceof EntityWolf) && ((EntityTameable)target).func_70902_q() == player) {
            if (stack.func_77942_o()) {
                if (target.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.pet_carrier.full", new Object[0]));
                }
            } else {
                stack = player.func_184586_b(hand);
                NBTTagCompound tags = new NBTTagCompound();
                target.func_189511_e(tags);
                target.func_70106_y();
                tags.func_74778_a("id", EntityList.func_75621_b((Entity)target));
                for (Map.Entry f : ForgeRegistries.ENTITIES.getEntries()) {
                    if (((EntityEntry)f.getValue()).getEntityClass() != target.getClass()) continue;
                    tags.func_74778_a("Entity", String.valueOf(f.getKey()));
                }
                if (target instanceof EntityWolf) {
                    tags.func_74778_a("OwnerName", player.getDisplayNameString());
                }
                if (target.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.pet_carrier.retrieve_pet", new Object[0]));
                }
                stack.func_77982_d(tags);
                player.func_184609_a(hand);
                if (target instanceof EntityCat) {
                    stack.func_77964_b(1);
                } else {
                    stack.func_77964_b(2);
                }
            }
        }
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        ItemStack item = player.func_184586_b(hand);
        if (!item.func_77942_o() || item.func_77952_i() == 0) {
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.pet_carrier.empty", new Object[0]));
            }
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            if (item.func_77952_i() == 1 || item.func_77952_i() == 2) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.pet_carrier.release_pet", new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(world, blockpos);
        if (item.func_77952_i() == 3 || item.func_77952_i() == 4) {
            this.newPet(item, player, world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
            if (!player.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
                if (item.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
        } else {
            NBTTagCompound tags = item.func_77978_p();
            tags.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5));
            tags.func_74782_a("Rotation", (NBTBase)this.newFloatNBTList(MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f));
            tags.func_74782_a("Motion", (NBTBase)this.newDoubleNBTList(0.0, 0.0, 0.0));
            tags.func_74776_a("FallDistance", 0.0f);
            if (item.func_77952_i() == 1 || item.func_77952_i() == 2) {
                Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(tags.func_74779_i("Entity")), (World)world);
                entity.func_70020_e(tags);
                world.func_72838_d(entity);
                item.func_77982_d(null);
                item.func_77964_b(0);
            }
        }
        player.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }

    private NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d1 : par1ArrayOfDouble) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    private NBTTagList newFloatNBTList(float ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float f : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        return nbttaglist;
    }

    private double getYOffset(World p_190909_1_, BlockPos p_190909_2_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_190909_2_).func_72321_a(0.0, -1.0, 0.0);
        List list = p_190909_1_.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)p_190909_2_.func_177956_o();
    }

    private void newPet(ItemStack item, EntityPlayer player, World world, double x, double y, double z) {
        EntityCat pet = null;
        if (item.func_77952_i() == 3) {
            pet = new EntityCat(world);
        } else if (item.func_77952_i() == 4) {
            pet = new EntityWolf(world);
        }
        if (pet instanceof EntityCat && !pet.canBeTamed(player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.info.tamed_limit_reached", new Object[0]));
        } else if (pet != null) {
            pet.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            pet.field_70759_as = pet.field_70177_z;
            pet.field_70761_aq = pet.field_70177_z;
            world.func_72838_d((Entity)pet);
            if (pet instanceof EntityCat) {
                pet.setTamed(true, player);
            } else {
                pet.func_70903_f(true);
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = world.field_73012_v.nextGaussian() * 0.02;
                    double d1 = world.field_73012_v.nextGaussian() * 0.02;
                    double d2 = world.field_73012_v.nextGaussian() * 0.02;
                    world.func_175688_a(EnumParticleTypes.HEART, pet.field_70165_t + (double)(world.field_73012_v.nextFloat() * pet.field_70130_N * 2.0f) - (double)pet.field_70130_N, pet.field_70163_u + 0.5 + (double)(world.field_73012_v.nextFloat() * pet.field_70131_O), pet.field_70161_v + (double)(world.field_73012_v.nextFloat() * pet.field_70130_N * 2.0f) - (double)pet.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
            if (pet instanceof EntityCat) {
                pet.setHomePos(new BlockPos(x, y, z));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.info.set_home", new Object[]{pet.func_70005_c_(), x, y, z}));
            }
            pet.func_70661_as().func_75499_g();
            pet.func_184754_b(player.func_110124_au());
            pet.func_180482_a(world.func_175649_E(new BlockPos((Entity)pet)), null);
            float health = pet.func_110138_aP();
            pet.func_70606_j(health);
        }
    }

    public String func_77653_i(ItemStack item) {
        String unlocalizedName = this.func_77657_g(item);
        unlocalizedName = !item.func_77942_o() || item.func_77952_i() == 0 ? unlocalizedName + ".empty.name" : unlocalizedName + ".full.name";
        return new TextComponentTranslation(unlocalizedName, new Object[0]).func_150260_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        if (tab == this.func_77640_w()) {
            ItemStack cat = new ItemStack((Item)ModItems.PET_CARRIER, 1);
            cat.func_77982_d(new NBTTagCompound());
            cat.func_77964_b(3);
            itemList.add((Object)cat);
            itemList.add((Object)new ItemStack((Item)ModItems.PET_CARRIER, 1, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null) {
            TextComponentTranslation cat = new TextComponentTranslation("tooltip.pet_carrier.adopt_cat", new Object[0]);
            TextComponentTranslation dog = new TextComponentTranslation("tooltip.pet_carrier.adopt_dog", new Object[0]);
            if (item.func_77952_i() == 3) {
                tooltip.add(TextFormatting.ITALIC + cat.func_150254_d());
            } else if (item.func_77952_i() == 4) {
                tooltip.add(TextFormatting.ITALIC + dog.func_150254_d());
            } else if (item.func_77952_i() != 0) {
                TextComponentTranslation species = new TextComponentTranslation("entity." + nbt.func_74779_i("id") + ".name", new Object[0]);
                String owner = I18n.func_135052_a((String)"tooltip.pet_carrier.owner", (Object[])new Object[]{nbt.func_74779_i("OwnerName")});
                if (nbt.func_74764_b("CustomName")) {
                    tooltip.add(TextFormatting.AQUA + "\"" + nbt.func_74779_i("CustomName") + "\"");
                } else {
                    tooltip.add(TextFormatting.AQUA + species.func_150260_c());
                }
                if (item.func_77952_i() == 1) {
                    tooltip.add(TextFormatting.ITALIC + Genetics.getPhenotypeDescription(nbt, true));
                }
                tooltip.add(owner);
            }
        } else {
            TextComponentTranslation empty = new TextComponentTranslation("tooltip.pet_carrier.empty", new Object[0]);
            tooltip.add(TextFormatting.AQUA + empty.func_150254_d());
        }
    }
}

