/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.init;

import com.github.mnesikos.simplycats.item.ItemBase;
import com.github.mnesikos.simplycats.item.ItemCatBook;
import com.github.mnesikos.simplycats.item.ItemCatBowl;
import com.github.mnesikos.simplycats.item.ItemCatnip;
import com.github.mnesikos.simplycats.item.ItemCatnipSeeds;
import com.github.mnesikos.simplycats.item.ItemCertificate;
import com.github.mnesikos.simplycats.item.ItemLaserPointer;
import com.github.mnesikos.simplycats.item.ItemLitterBox;
import com.github.mnesikos.simplycats.item.ItemPetCarrier;
import com.github.mnesikos.simplycats.item.ItemScratchingPost;
import com.github.mnesikos.simplycats.item.ItemSterilizationPotion;
import com.github.mnesikos.simplycats.item.ItemTreatBag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockPlanks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static final ItemBase CAT_BOOK = new ItemCatBook("cat_book");
    public static final ItemBase PET_CARRIER = new ItemPetCarrier();
    public static final ItemBase CERTIFICATE = new ItemCertificate("certificate");
    public static final ItemBase TREAT_BAG = new ItemTreatBag("treat_bag");
    public static final ItemBase CATNIP = new ItemCatnip("catnip");
    public static final ItemCatnipSeeds CATNIP_SEEDS = new ItemCatnipSeeds("catnip_seeds");
    public static final ItemLaserPointer LASER_POINTER = new ItemLaserPointer("laser_pointer");
    public static final ItemSterilizationPotion STERILIZE_POTION = new ItemSterilizationPotion("sterilization_potion");
    public static final Map<EnumDyeColor, ItemCatBowl> CAT_BOWLS = new HashMap<EnumDyeColor, ItemCatBowl>();
    public static final Map<EnumDyeColor, ItemLitterBox> LITTER_BOXES = new HashMap<EnumDyeColor, ItemLitterBox>();
    public static final Map<BlockPlanks.EnumType, ItemScratchingPost> SCRATCHING_POSTS = new HashMap<BlockPlanks.EnumType, ItemScratchingPost>();

    public static void registerOres() {
        OreDictionary.registerOre((String)"cropCatnip", (Item)CATNIP);
        OreDictionary.registerOre((String)"cropCatmint", (Item)CATNIP);
    }

    public static void register(IForgeRegistry<Item> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Item[]{CAT_BOOK, PET_CARRIER, CERTIFICATE, TREAT_BAG, CATNIP, CATNIP_SEEDS, LASER_POINTER, STERILIZE_POTION});
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            CAT_BOWLS.put(enumDyeColor, new ItemCatBowl("cat_bowl", enumDyeColor));
            registry.register((IForgeRegistryEntry)CAT_BOWLS.get(enumDyeColor));
            LITTER_BOXES.put(enumDyeColor, new ItemLitterBox("litter_box", enumDyeColor));
            registry.register((IForgeRegistryEntry)LITTER_BOXES.get(enumDyeColor));
        }
        for (EnumDyeColor enumDyeColor : BlockPlanks.EnumType.values()) {
            SCRATCHING_POSTS.put((BlockPlanks.EnumType)enumDyeColor, new ItemScratchingPost("scratching_post", (BlockPlanks.EnumType)enumDyeColor));
            registry.register((IForgeRegistryEntry)SCRATCHING_POSTS.get(enumDyeColor));
        }
    }

    public static void registerModels() {
        CAT_BOOK.registerItemModel();
        PET_CARRIER.registerItemModel();
        CERTIFICATE.registerItemModel();
        TREAT_BAG.registerItemModel();
        CATNIP.registerItemModel();
        CATNIP_SEEDS.registerItemModel();
        LASER_POINTER.registerItemModel();
        STERILIZE_POTION.registerItemModel();
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            CAT_BOWLS.get(enumDyeColor).registerItemModel();
            LITTER_BOXES.get(enumDyeColor).registerItemModel();
        }
        for (EnumDyeColor enumDyeColor : BlockPlanks.EnumType.values()) {
            SCRATCHING_POSTS.get(enumDyeColor).registerItemModel();
        }
    }
}

