/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.event;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.AbstractCat;
import com.github.mnesikos.simplycats.entity.EntityCat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SCEvents {
    private static Set<Class<? extends Entity>> entities;

    public static boolean isEntityPrey(@Nullable Entity entity) {
        if (entities == null) {
            entities = new HashSet<Class<? extends Entity>>();
            for (String s : SCConfig.PREY_LIST) {
                ResourceLocation location = new ResourceLocation(s);
                if (!ForgeRegistries.ENTITIES.containsKey(location)) continue;
                entities.add(((EntityEntry)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(location))).getEntityClass());
            }
        }
        return entities.contains(entity.getClass());
    }

    public static boolean isRatEntity(Entity entity) {
        String entityClass = EntityList.func_191301_a((Entity)entity).toString();
        return entityClass.equals("rats:rat");
    }

    @SubscribeEvent
    public void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (SCConfig.JOIN_MESSAGE) {
            EntityPlayer player = event.player;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.join.cat_count", new Object[]{player.getEntityData().func_74762_e("CatCount")}));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        EntityCat cat;
        IAttributeInstance maxHealth;
        if (event.getEntity() instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)event.getEntity();
            creeper.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)creeper, AbstractCat.class, 6.0f, 1.0, 1.2));
        }
        if (event.getEntity() instanceof EntityCat && (maxHealth = (cat = (EntityCat)event.getEntity()).func_110148_a(SharedMonsterAttributes.field_111267_a)).func_111125_b() < 14.0) {
            maxHealth.func_111128_a(14.0);
            cat.func_70606_j(14.0f);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        EntityLiving attackingEntity;
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityLiving && (attackingEntity = (EntityLiving)event.getEntityLiving()) instanceof EntityWitch && !attackingEntity.field_70170_p.func_72872_a(AbstractCat.class, attackingEntity.func_174813_aQ().func_186662_g(16.0)).isEmpty()) {
            attackingEntity.func_70624_b(null);
        }
    }
}

