/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.core;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;

public class Genetics {
    public static String getPhenotypeDescription(NBTTagCompound nbt, boolean includeSex) {
        boolean red;
        String sex = Sex.getPrettyName(nbt.func_74779_i("Phaeomelanin").contains(Phaeomelanin.MALE.getAllele()) ? "male" : "female");
        String eumelanin = Eumelanin.getPhenotype(nbt.func_74779_i("Eumelanin"));
        String phaeomelanin = Phaeomelanin.getPhenotype(nbt.func_74779_i("Phaeomelanin"));
        String dilution = Dilution.getPhenotype(nbt.func_74779_i("Dilution"));
        String diluteMod = DiluteMod.getPhenotype(nbt.func_74779_i("DiluteMod"));
        TextComponentTranslation base = new TextComponentTranslation("cat.base." + eumelanin + (phaeomelanin.equals(Phaeomelanin.NOT_RED.toString().toLowerCase()) ? "" : "_" + phaeomelanin) + ".name", new Object[0]);
        boolean dilute = dilution.equals(Dilution.DILUTE.toString().toLowerCase());
        boolean caramelized = diluteMod.equals(DiluteMod.CARAMELIZED.toString().toLowerCase());
        if (dilute) {
            base = new TextComponentTranslation("cat.base." + eumelanin + "_" + phaeomelanin + "_" + dilution + ".name", new Object[0]);
            if (caramelized) {
                base = new TextComponentTranslation("cat.base." + eumelanin + "_" + phaeomelanin + "_" + diluteMod + ".name", new Object[0]);
            }
        }
        if (red = phaeomelanin.equals(Phaeomelanin.RED.toString().toLowerCase())) {
            base = new TextComponentTranslation("cat.base." + phaeomelanin + ".name", new Object[0]);
            if (dilute) {
                base = new TextComponentTranslation("cat.base." + phaeomelanin + "_" + dilution + ".name", new Object[0]);
                if (caramelized) {
                    base = new TextComponentTranslation("cat.base." + phaeomelanin + "_" + diluteMod + ".name", new Object[0]);
                }
            }
        }
        String agouti = Agouti.getPhenotype(nbt.func_74779_i("Agouti"));
        String tabby1 = Tabby.getPhenotype(nbt.func_74779_i("Tabby"));
        String spotted = Spotted.getPhenotype(nbt.func_74779_i("Spotted"));
        String ticked = Ticked.getPhenotype(nbt.func_74779_i("Ticked"));
        TextComponentTranslation tabby = new TextComponentTranslation("", new Object[0]);
        if (agouti.equals(Agouti.TABBY.toString().toLowerCase()) || red) {
            tabby = new TextComponentTranslation("cat.tabby." + tabby1 + ".name", new Object[0]);
            if (spotted.equals(Spotted.BROKEN.toString().toLowerCase()) || spotted.equals(Spotted.SPOTTED.toString().toLowerCase())) {
                tabby = new TextComponentTranslation("cat.tabby." + spotted + ".name", new Object[0]);
            }
            if (ticked.equals(Ticked.TICKED.toString().toLowerCase())) {
                tabby = new TextComponentTranslation("cat.tabby." + ticked + ".name", new Object[0]);
            }
        }
        String colorpoint = Colorpoint.getPhenotype(nbt.func_74779_i("Colorpoint"));
        TextComponentTranslation point = new TextComponentTranslation("", new Object[0]);
        if (!colorpoint.equals(Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            point = new TextComponentTranslation("cat.point." + colorpoint + ".name", new Object[0]);
        }
        String white = White.getPhenotype(nbt.func_74779_i("White"));
        TextComponentTranslation whiteText = new TextComponentTranslation("", new Object[0]);
        if (!white.equals(White.NONE.toString().toLowerCase())) {
            if (white.equals(White.DOMINANT.toString().toLowerCase()) || nbt.func_74779_i("White_0").contains("6")) {
                whiteText = new TextComponentTranslation("cat.white.solid_white.name", new Object[0]);
                return whiteText.func_150260_c() + (includeSex ? " " + sex : "");
            }
            if (nbt.func_74779_i("White_0").contains("5")) {
                whiteText = new TextComponentTranslation("cat.white.mostly_white.name", new Object[0]);
                return whiteText.func_150260_c() + " " + base.func_150260_c() + (tabby.func_150260_c().equals("") ? "" : " " + tabby.func_150260_c()) + (point.func_150260_c().equals("") ? "" : " " + point.func_150260_c()) + (includeSex ? " " + sex : "");
            }
            whiteText = new TextComponentTranslation("cat.white.some_white.name", new Object[0]);
        }
        return base.func_150260_c() + (tabby.func_150260_c().equals("") ? "" : " " + tabby.func_150260_c()) + (point.func_150260_c().equals("") ? "" : " " + point.func_150260_c()) + " " + whiteText.func_150260_c() + (includeSex ? " " + sex : "");
    }

    public static enum Bobtail {
        FULL("Jb"),
        BOBTAIL("jb");

        private String allele;

        private Bobtail(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.98f) {
                return FULL.getAllele();
            }
            return BOBTAIL.getAllele();
        }

        public static boolean isBobtail(String bobtail) {
            return bobtail.equals("jb-jb");
        }
    }

    public static enum White {
        NONE("w"),
        SPOTTING("Ws"),
        DOMINANT("Wd");

        private String allele;

        private White(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.49f) {
                return NONE.getAllele();
            }
            if (chance > 0.49f && chance <= 0.98f) {
                return SPOTTING.getAllele();
            }
            return DOMINANT.getAllele();
        }

        public static String getPhenotype(String white) {
            switch (white) {
                case "Wd-Wd": 
                case "Wd-w": 
                case "Wd-Ws": 
                case "w-Wd": 
                case "Ws-Wd": {
                    return DOMINANT.toString().toLowerCase();
                }
                case "Ws-Ws": 
                case "Ws-w": 
                case "w-Ws": {
                    return SPOTTING.toString().toLowerCase();
                }
                case "w-w": {
                    return NONE.toString().toLowerCase();
                }
            }
            throw new IllegalArgumentException("Invalid white: " + white);
        }
    }

    public static enum Colorpoint {
        NOT_POINTED("C"),
        COLORPOINT("cs"),
        SEPIA("cb"),
        MINK;

        private String allele;

        private Colorpoint(String allele) {
            this.allele = allele;
        }

        private Colorpoint() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return NOT_POINTED.getAllele();
            }
            if (chance > 0.8f && chance <= 0.96f) {
                return COLORPOINT.getAllele();
            }
            return SEPIA.getAllele();
        }

        public static String getPhenotype(String colorpoint) {
            switch (colorpoint) {
                case "C-C": 
                case "C-cs": 
                case "C-cb": 
                case "cs-C": 
                case "cb-C": {
                    return NOT_POINTED.toString().toLowerCase();
                }
                case "cs-cs": {
                    return COLORPOINT.toString().toLowerCase();
                }
                case "cs-cb": 
                case "cb-cs": {
                    return MINK.toString().toLowerCase();
                }
                case "cb-cb": {
                    return SEPIA.toString().toLowerCase();
                }
            }
            throw new IllegalArgumentException("Invalid colorpoint: " + colorpoint);
        }
    }

    public static enum Ticked {
        NORMAL("ta"),
        TICKED("Ta");

        private String allele;

        private Ticked(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.96f) {
                return NORMAL.getAllele();
            }
            return TICKED.getAllele();
        }

        public static String getPhenotype(String ticked) {
            String[] value = ticked.split("-");
            if (value[0].equals("Ta") || value[1].equals("Ta")) {
                return TICKED.toString().toLowerCase();
            }
            return NORMAL.toString().toLowerCase();
        }
    }

    public static enum Spotted {
        NORMAL("sp"),
        SPOTTED("Sp"),
        BROKEN;

        private String allele;

        private Spotted(String allele) {
            this.allele = allele;
        }

        private Spotted() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return NORMAL.getAllele();
            }
            return SPOTTED.getAllele();
        }

        public static String getPhenotype(String spotted) {
            switch (spotted) {
                case "Sp-Sp": {
                    return SPOTTED.toString().toLowerCase();
                }
                case "Sp-sp": 
                case "sp-Sp": {
                    return BROKEN.toString().toLowerCase();
                }
                case "sp-sp": {
                    return NORMAL.toString().toLowerCase();
                }
            }
            throw new IllegalArgumentException("Invalid spotted: " + spotted);
        }
    }

    public static enum Tabby {
        MACKEREL("Mc"),
        CLASSIC("mc");

        private String allele;

        private Tabby(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.5f) {
                return MACKEREL.getAllele();
            }
            return CLASSIC.getAllele();
        }

        public static String getPhenotype(String tabby) {
            String[] value = tabby.split("-");
            if (value[0].equals("Mc") || value[1].equals("Mc")) {
                return MACKEREL.toString().toLowerCase();
            }
            return CLASSIC.toString().toLowerCase();
        }
    }

    public static enum Agouti {
        SOLID("a"),
        TABBY("A");

        private String allele;

        private Agouti(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return SOLID.getAllele();
            }
            return TABBY.getAllele();
        }

        public static String getPhenotype(String agouti) {
            String[] value = agouti.split("-");
            if (value[0].equals("A") || value[1].equals("A")) {
                return TABBY.toString().toLowerCase();
            }
            return SOLID.toString().toLowerCase();
        }
    }

    public static enum DiluteMod {
        NORMAL("dm"),
        CARAMELIZED("Dm");

        private String allele;

        private DiluteMod(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.96f) {
                return NORMAL.getAllele();
            }
            return CARAMELIZED.getAllele();
        }

        public static String getPhenotype(String diluteMod) {
            String[] value = diluteMod.split("-");
            if (value[0].equals("Dm") || value[1].equals("Dm")) {
                return CARAMELIZED.toString().toLowerCase();
            }
            return NORMAL.toString().toLowerCase();
        }
    }

    public static enum Dilution {
        NON_DILUTE("D"),
        DILUTE("d");

        private String allele;

        private Dilution(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.6f) {
                return NON_DILUTE.getAllele();
            }
            return DILUTE.getAllele();
        }

        public static String getPhenotype(String dilution) {
            String[] value = dilution.split("-");
            if (value[0].equals("D") || value[1].equals("D")) {
                return NON_DILUTE.toString().toLowerCase();
            }
            return DILUTE.toString().toLowerCase();
        }
    }

    public static enum Phaeomelanin {
        NOT_RED("Xo"),
        RED("XO"),
        MALE("Y"),
        TORTOISESHELL;

        private String allele;

        private Phaeomelanin(String allele) {
            this.allele = allele;
        }

        private Phaeomelanin() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance1 = rand.nextFloat();
            String allele1 = chance1 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele();
            float chance2 = rand.nextFloat();
            String allele2 = allele1.equals(NOT_RED.getAllele()) ? (chance2 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele()) : (chance2 <= 0.75f ? RED.getAllele() : NOT_RED.getAllele());
            return allele1 + "-" + (rand.nextInt(2) == 0 ? MALE.getAllele() : allele2);
        }

        public static String getPhenotype(String phaeomelanin) {
            switch (phaeomelanin) {
                case "XO-Y": 
                case "XO-XO": {
                    return RED.toString().toLowerCase();
                }
                case "Xo-Y": 
                case "Xo-Xo": {
                    return NOT_RED.toString().toLowerCase();
                }
                case "XO-Xo": 
                case "Xo-XO": {
                    return TORTOISESHELL.toString().toLowerCase();
                }
            }
            throw new IllegalArgumentException("Invalid phaeomelanin: " + phaeomelanin);
        }
    }

    public static enum Eumelanin {
        BLACK("B"),
        CHOCOLATE("b"),
        CINNAMON("b1");

        private String allele;

        private Eumelanin(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.8f) {
                return BLACK.getAllele();
            }
            if (chance > 0.8f && chance <= 0.96f) {
                return CHOCOLATE.getAllele();
            }
            return CINNAMON.getAllele();
        }

        public static String getPhenotype(String eumelanin) {
            String[] value = eumelanin.split("-");
            if (value[0].equals("B") || value[1].equals("B")) {
                return BLACK.toString().toLowerCase();
            }
            if (value[0].equals("b") || value[1].equals("b")) {
                return CHOCOLATE.toString().toLowerCase();
            }
            return CINNAMON.toString().toLowerCase();
        }
    }

    public static enum FurLength {
        SHORT("L"),
        LONG("l");

        private String allele;

        private FurLength(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init() {
            Random rand = new Random();
            float chance = rand.nextFloat();
            if (chance <= 0.75f) {
                return SHORT.getAllele();
            }
            return LONG.getAllele();
        }

        public static String getPhenotype(String furLength) {
            String[] value = furLength.split("-");
            if (value[0].equals("L") || value[1].equals("L")) {
                return SHORT.toString().toLowerCase();
            }
            return LONG.toString().toLowerCase();
        }
    }

    public static enum EyeColor {
        COPPER,
        GOLD,
        HAZEL,
        GREEN,
        BLUE,
        ODD_LEFT,
        ODD_RIGHT;


        public static String init(int value) {
            switch (value) {
                case 0: {
                    return COPPER.toString().toLowerCase();
                }
                case 1: {
                    return GOLD.toString().toLowerCase();
                }
                case 2: {
                    return HAZEL.toString().toLowerCase();
                }
                case 3: {
                    return GREEN.toString().toLowerCase();
                }
                case 4: {
                    return BLUE.toString().toLowerCase();
                }
            }
            throw new IllegalArgumentException("Invalid eye color value: " + value);
        }
    }

    public static enum Sex {
        MALE("male"),
        FEMALE("female");

        private String name;

        private Sex(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static String getPrettyName(String name) {
            if (name.equalsIgnoreCase(Sex.MALE.name)) {
                return "Male";
            }
            if (name.equalsIgnoreCase(Sex.FEMALE.name)) {
                return "Female";
            }
            return name;
        }
    }
}

