/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.ai;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.World;

public class CatAIMate
extends EntityAIBase {
    private static final double NEARBY_RADIUS_CHECK = 16.0;
    private final double moveSpeed;
    private final EntityCat cat;
    private EntityCat target;
    private int mateDelay;
    private List<EntityCat> nearbyCats;

    public CatAIMate(EntityCat entityCat, double speed) {
        this.cat = entityCat;
        this.moveSpeed = speed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        World world = this.cat.field_70170_p;
        if (this.cat.getSex() == Genetics.Sex.FEMALE) {
            return false;
        }
        this.nearbyCats = world.func_72872_a(((Object)((Object)this.cat)).getClass(), this.cat.func_174813_aQ().func_186662_g(16.0));
        if (this.nearbyCats.size() >= SCConfig.BREEDING_LIMIT) {
            return false;
        }
        EntityLivingBase catOwner = this.cat.func_70902_q();
        if (this.ownerExceedsLimit(this.cat, catOwner) || this.ownerIsOffline(this.cat, catOwner) || this.cat.getMateTimer() > 0) {
            return false;
        }
        this.target = this.getNearbyMate();
        if (this.target != null && this.cat.func_70635_at().func_75522_a((Entity)this.target) && this.target.getBreedingStatus("inheat")) {
            if (!this.target.func_70909_n()) {
                return true;
            }
            EntityLivingBase targetOwner = this.target.func_70902_q();
            return !this.ownerExceedsLimit(this.target, targetOwner) && !this.ownerIsOffline(this.target, targetOwner);
        }
        return false;
    }

    public boolean func_75253_b() {
        World world = this.cat.field_70170_p;
        boolean maleCooldownCheck = this.cat.getSex() == Genetics.Sex.MALE && this.cat.getMateTimer() == 0;
        boolean femaleHeatCheck = this.target.getSex() == Genetics.Sex.FEMALE && this.target.getBreedingStatus("inheat");
        this.nearbyCats = world.func_72872_a(((Object)((Object)this.cat)).getClass(), this.cat.func_174813_aQ().func_186662_g(16.0));
        return maleCooldownCheck && this.target.func_70089_S() && femaleHeatCheck && this.mateDelay < 60 && this.nearbyCats.size() < SCConfig.BREEDING_LIMIT && this.cat.func_70635_at().func_75522_a((Entity)this.target);
    }

    private boolean ownerExceedsLimit(EntityCat tamedCat, EntityLivingBase owner) {
        return tamedCat != null && tamedCat.func_70909_n() && SCConfig.TAMED_LIMIT != 0 && owner != null && owner.getEntityData().func_74762_e("CatCount") >= SCConfig.TAMED_LIMIT;
    }

    private boolean ownerIsOffline(EntityCat tamedCat, EntityLivingBase owner) {
        return tamedCat != null && tamedCat.func_70909_n() && owner == null;
    }

    public void func_75251_c() {
        this.target = null;
        this.mateDelay = 0;
        this.nearbyCats.clear();
    }

    public void func_75246_d() {
        World world = this.cat.field_70170_p;
        this.cat.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.cat.func_70646_bf());
        this.target.func_70671_ap().func_75651_a((Entity)this.cat, 10.0f, (float)this.target.func_70646_bf());
        this.cat.func_70661_as().func_75497_a((Entity)this.target, this.moveSpeed);
        this.target.func_70661_as().func_75497_a((Entity)this.cat, this.moveSpeed);
        ++this.mateDelay;
        if (this.mateDelay >= 60 && this.cat.func_70068_e((Entity)this.target) < 4.0) {
            if (world.field_73012_v.nextInt(4) <= 2) {
                this.startPregnancy();
            }
            this.cat.setMateTimer(SCConfig.MALE_COOLDOWN);
        }
    }

    private EntityCat getNearbyMate() {
        World world = this.cat.field_70170_p;
        List list = world.func_72872_a(((Object)((Object)this.cat)).getClass(), this.cat.func_174813_aQ().func_186662_g(16.0));
        double d0 = Double.MAX_VALUE;
        EntityCat entityCat = null;
        if (this.cat.getSex() == Genetics.Sex.MALE) {
            for (EntityCat cat1 : list) {
                if (!this.cat.func_70878_b((EntityAnimal)cat1) || !(this.cat.func_70068_e((Entity)cat1) < d0)) continue;
                entityCat = cat1;
                d0 = this.cat.func_70068_e((Entity)cat1);
            }
        }
        return entityCat;
    }

    private void startPregnancy() {
        World world = this.cat.field_70170_p;
        int litterSize = this.target.getKittens() <= 0 ? world.field_73012_v.nextInt(6) + 1 : world.field_73012_v.nextInt(6 - this.target.getKittens()) + 1;
        this.target.setBreedingStatus("ispregnant", true);
        this.target.setKittens(litterSize);
        this.target.addFather(this.cat, this.target.getKittens());
        if (litterSize == 6 || this.target.getKittens() == 6 || world.field_73012_v.nextInt(4) == 0) {
            this.target.setBreedingStatus("inheat", false);
            this.target.setTimeCycle("pregnancy", SCConfig.PREGNANCY_TIMER);
        }
    }
}

