/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity;

import com.github.mnesikos.simplycats.Ref;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.AbstractCat;
import com.github.mnesikos.simplycats.entity.ai.CatAIAttack;
import com.github.mnesikos.simplycats.entity.ai.CatAIBirth;
import com.github.mnesikos.simplycats.entity.ai.CatAIMate;
import com.github.mnesikos.simplycats.entity.ai.CatAITargetNearest;
import com.github.mnesikos.simplycats.entity.ai.CatAIWander;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.event.SCEvents;
import com.github.mnesikos.simplycats.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityCat
extends AbstractCat {
    private static final DataParameter<Byte> FIXED = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> IN_HEAT = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> IS_PREGNANT = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> MATE_TIMER = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KITTENS = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> MOTHER = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> FATHER = EntityDataManager.func_187226_a(EntityCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private EntityAITempt aiTempt;
    private CatAITargetNearest aiTargetNearest;
    private Vec3d nearestLaser;

    public EntityCat(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.setParent("mother", "Unknown");
        this.setParent("father", "Unknown");
    }

    public Vec3d getNearestLaser() {
        return this.nearestLaser;
    }

    public void setNearestLaser(Vec3d vec) {
        this.nearestLaser = vec;
        if (vec == null) {
            this.func_70661_as().func_75499_g();
        }
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 1.2, (Item)ModItems.TREAT_BAG, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        if (!this.isFixed()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new CatAIMate(this, 1.2));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new CatAIBirth(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new CatAIAttack((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new CatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 7.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (SCConfig.ATTACK_AI) {
            this.aiTargetNearest = new CatAITargetNearest<EntityLivingBase>(this, EntityLivingBase.class, true, entity -> {
                if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
                    return false;
                }
                return entity != null && !(entity instanceof EntityCat) && !(entity instanceof EntityPlayer) && !(entity instanceof IMob) && !entity.func_184191_r((Entity)this) && SCEvents.isEntityPrey((Entity)entity);
            });
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiTargetNearest);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.7);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIXED, (Object)0);
        this.field_70180_af.func_187214_a(IN_HEAT, (Object)0);
        this.field_70180_af.func_187214_a(IS_PREGNANT, (Object)0);
        this.field_70180_af.func_187214_a(MATE_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(KITTENS, (Object)0);
        this.field_70180_af.func_187214_a(MOTHER, (Object)"Unknown");
        this.field_70180_af.func_187214_a(FATHER, (Object)"Unknown");
    }

    protected void func_70619_bc() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || !SCConfig.ATTACK_AI) {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiTargetNearest);
        }
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_70095_a(true);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_70095_a(false);
                this.func_70031_b(true);
            } else {
                this.func_70095_a(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_70095_a(false);
            this.func_70031_b(false);
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.field_70170_p.field_72995_K && this.func_70909_n()) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
        }
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setTimeCycle("end", this.field_70170_p.field_73012_v.nextInt(SCConfig.HEAT_COOLDOWN));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getNearestLaser() != null) {
            if (this.field_70911_d != null && this.func_70906_o()) {
                this.field_70911_d.func_75270_a(false);
            }
            this.func_70661_as().func_75492_a(this.getNearestLaser().field_72450_a, this.getNearestLaser().field_72448_b, this.getNearestLaser().field_72449_c, 1.2);
            this.func_70671_ap().func_75650_a(this.getNearestLaser().field_72450_a, this.getNearestLaser().field_72448_b, this.getNearestLaser().field_72449_c, 10.0f, (float)this.func_70646_bf());
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.isFixed() || this.getSex() != Genetics.Sex.FEMALE)) {
            if (this.getBreedingStatus("inheat") && this.getMateTimer() <= 0) {
                if (!this.getBreedingStatus("ispregnant")) {
                    this.setTimeCycle("end", SCConfig.HEAT_COOLDOWN);
                } else {
                    this.setTimeCycle("pregnant", SCConfig.PREGNANCY_TIMER);
                    this.setBreedingStatus("inheat", false);
                }
            }
            if (!this.getBreedingStatus("inheat") && this.getMateTimer() >= 0 && !this.getBreedingStatus("ispregnant")) {
                this.setTimeCycle("start", SCConfig.HEAT_TIMER);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70631_g_() && !this.isFixed()) {
            int mateTimer = this.getMateTimer();
            if (this.getSex() == Genetics.Sex.FEMALE) {
                if (this.getBreedingStatus("inheat") || this.getBreedingStatus("ispregnant")) {
                    if (this.getBreedingStatus("inheat") && --mateTimer % 10 == 0) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                } else if (!this.getBreedingStatus("inheat") && !this.getBreedingStatus("ispregnant")) {
                    ++mateTimer;
                }
            } else if (this.getSex() == Genetics.Sex.MALE) {
                if (mateTimer > 0) {
                    --mateTimer;
                } else if (mateTimer <= 0) {
                    mateTimer = 0;
                }
            }
            this.setMateTimer(mateTimer);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.func_70909_n() && this.func_70902_q() == null) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entity) {
        float damage = (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (SCEvents.isRatEntity(entity)) {
            damage *= 3.0f;
        }
        if (this.func_70093_af() || this.func_70051_ag()) {
            damage *= 2.0f;
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public boolean func_184191_r(Entity entity) {
        EntityTameable tameable;
        if (entity instanceof EntityTameable && (tameable = (EntityTameable)entity).func_70909_n() && tameable.func_184753_b() != null && this.func_70909_n() && this.func_184753_b() != null && this.func_184753_b().equals(tameable.func_184753_b())) {
            return true;
        }
        return super.func_184191_r(entity);
    }

    public void onBagShake(EntityPlayer player) {
        if (!this.func_70909_n() || this.func_152114_e((EntityLivingBase)player) && !this.func_70906_o()) {
            this.func_70671_ap().func_75651_a((Entity)player, 10.0f, (float)this.func_70646_bf());
            this.func_70661_as().func_75497_a((Entity)player, 1.8);
        }
    }

    public void setParent(String parent, String name) {
        if (parent.equals("mother")) {
            this.field_70180_af.func_187227_b(MOTHER, (Object)name);
        } else if (parent.equals("father")) {
            this.field_70180_af.func_187227_b(FATHER, (Object)name);
        }
    }

    public String getParent(String parent) {
        switch (parent) {
            case "mother": {
                return (String)this.field_70180_af.func_187225_a(MOTHER);
            }
            case "father": {
                return (String)this.field_70180_af.func_187225_a(FATHER);
            }
        }
        return "Error";
    }

    public void setFixed(byte fixed) {
        this.field_70180_af.func_187227_b(FIXED, (Object)fixed);
    }

    public boolean isFixed() {
        return (Byte)this.field_70180_af.func_187225_a(FIXED) == 1;
    }

    public byte getIsFixed() {
        return (Byte)this.field_70180_af.func_187225_a(FIXED);
    }

    public void setTimeCycle(String s, int time) {
        if (s.equals("start")) {
            this.setBreedingStatus("inheat", true);
            this.setMateTimer(time);
        }
        if (s.equals("end")) {
            this.setBreedingStatus("inheat", false);
            this.setMateTimer(-time);
        }
        if (s.equals("pregnancy")) {
            this.setMateTimer(time);
        }
    }

    public void setBreedingStatus(String string, boolean parTrue) {
        if (string.equals("inheat")) {
            if (parTrue) {
                this.field_70180_af.func_187227_b(IN_HEAT, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(IN_HEAT, (Object)0);
            }
        } else if (string.equals("ispregnant")) {
            if (parTrue) {
                this.field_70180_af.func_187227_b(IS_PREGNANT, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(IS_PREGNANT, (Object)0);
            }
        }
    }

    public boolean getBreedingStatus(String string) {
        if (string.equals("inheat")) {
            return (Byte)this.field_70180_af.func_187225_a(IN_HEAT) == 1;
        }
        if (string.equals("ispregnant")) {
            return (Byte)this.field_70180_af.func_187225_a(IS_PREGNANT) == 1;
        }
        return false;
    }

    public void setMateTimer(int time) {
        this.field_70180_af.func_187227_b(MATE_TIMER, (Object)time);
    }

    public int getMateTimer() {
        return (Integer)this.field_70180_af.func_187225_a(MATE_TIMER);
    }

    public void setKittens(int kittens) {
        if (this.getKittens() <= 0 || kittens == 0) {
            this.field_70180_af.func_187227_b(KITTENS, (Object)kittens);
        } else if (this.getKittens() > 0) {
            this.field_70180_af.func_187227_b(KITTENS, (Object)(this.getKittens() + kittens));
        }
    }

    public int getKittens() {
        return (Integer)this.field_70180_af.func_187225_a(KITTENS);
    }

    public void addFather(EntityCat father, int size) {
        for (int i = 0; i < size; ++i) {
            if (this.getEntityData().func_74764_b("Father" + i) && (!this.getEntityData().func_74764_b("Father" + i) || this.getEntityData().func_74775_l("Father" + i) != null)) continue;
            this.getEntityData().func_74782_a("Father" + i, (NBTBase)father.func_189511_e(new NBTTagCompound()));
        }
    }

    private void setFather(int i, NBTBase father) {
        if (this.getEntityData().func_74764_b("Father" + i)) {
            this.getEntityData().func_74782_a("Father" + i, father);
        }
    }

    public NBTTagCompound getFather(int i) {
        return this.getEntityData().func_74775_l("Father" + i);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("Fixed", this.getIsFixed());
        if (this.getSex() == Genetics.Sex.FEMALE) {
            nbt.func_74757_a("InHeat", this.getBreedingStatus("inheat"));
            nbt.func_74757_a("IsPregnant", this.getBreedingStatus("ispregnant"));
            nbt.func_74768_a("Kittens", this.getKittens());
            for (int i = 0; i < 5; ++i) {
                nbt.func_74782_a("Father" + i, (NBTBase)this.getFather(i));
            }
        }
        nbt.func_74768_a("Timer", this.getMateTimer());
        nbt.func_74778_a("Mother", this.getParent("mother"));
        nbt.func_74778_a("Father", this.getParent("father"));
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFixed(nbt.func_74771_c("Fixed"));
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setBreedingStatus("inheat", nbt.func_74767_n("InHeat"));
            this.setBreedingStatus("ispregnant", nbt.func_74767_n("IsPregnant"));
            this.setKittens(nbt.func_74762_e("Kittens"));
            for (int i = 0; i < 5; ++i) {
                this.setFather(i, nbt.func_74781_a("Father" + i));
            }
        }
        if (!this.isFixed()) {
            this.setMateTimer(nbt.func_74762_e("Timer"));
        }
        this.setParent("mother", nbt.func_74779_i("Mother"));
        this.setParent("father", nbt.func_74779_i("Father"));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70878_b(EntityAnimal target) {
        if (target == this) {
            return false;
        }
        if (!(target instanceof EntityCat)) {
            return false;
        }
        if (target.func_70631_g_() || this.func_70631_g_()) {
            return false;
        }
        if (this.func_70906_o() || ((EntityCat)target).func_70906_o()) {
            return false;
        }
        EntityCat mate = (EntityCat)target;
        if (mate.isFixed() || this.isFixed()) {
            return false;
        }
        if (this.getSex() == Genetics.Sex.MALE && this.getMateTimer() == 0) {
            return mate.getSex() == Genetics.Sex.FEMALE && mate.getBreedingStatus("inheat");
        }
        return false;
    }

    public boolean func_70877_b(ItemStack item) {
        return item.func_77973_b() == Items.field_151065_br;
    }

    public EntityCat createChild(EntityAgeable parFather) {
        return (EntityCat)super.func_90011_a(parFather);
    }

    private boolean isFoodItem(ItemStack item) {
        return Ref.catFoodItems(item);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (this.func_70877_b(stack) && player.func_70093_af() && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
                if (this.func_70631_g_()) {
                    this.func_175505_a(player, stack);
                    this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.8f), true);
                } else if (!this.isFixed() && this.getMateTimer() != 0) {
                    this.func_175505_a(player, stack);
                    this.setMateTimer(this.getMateTimer() / 2);
                }
                return true;
            }
            if (this.isFoodItem(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                ItemFood food = (ItemFood)stack.func_77973_b();
                this.func_175505_a(player, stack);
                this.func_70691_i(food.func_150905_g(stack));
                return true;
            }
            if (stack.func_77973_b() == Items.field_151103_aS && player.func_70093_af()) {
                if (this.field_70170_p.field_72995_K && this.getSex() == Genetics.Sex.FEMALE && this.getBreedingStatus("ispregnant")) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.info.kitten_count", new Object[]{this.getKittens()}));
                }
                return true;
            }
            if ((this.aiTempt == null || this.aiTempt.func_75277_f()) && stack.func_77973_b() == ModItems.TREAT_BAG && player.func_70068_e((Entity)this) < 9.0) {
                if (player.func_70093_af()) {
                    if (this.hasHomePos()) {
                        this.resetHomePos();
                        if (this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.info.remove_home", new Object[]{this.func_70005_c_()}));
                        }
                    } else {
                        this.setHomePos(new BlockPos((Entity)this));
                        if (this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.info.set_home", new Object[]{this.func_70005_c_(), this.getHomePos().func_177958_n(), this.getHomePos().func_177956_o(), this.getHomePos().func_177952_p()}));
                        }
                    }
                    return true;
                }
                if (this.hasHomePos() && this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(this.getHomePos().func_177958_n() + ", " + this.getHomePos().func_177956_o() + ", " + this.getHomePos().func_177952_p()));
                }
            }
        }
        if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
        }
        return super.func_184645_a(player, hand);
    }
}

