/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.gui;

import gollorum.signpost.gui.SignInput;
import gollorum.signpost.management.PostHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class SignInputBox
extends Gui {
    private static final double pWidth = 25.0;
    private static final double pHeight = 6.0;
    private static final double verh = 4.166666666666667;
    public int x;
    public int y;
    public int width;
    public int height;
    private boolean isFocused = false;
    private int cursorPosition;
    private ArrayList<String> possible = new ArrayList();
    private int cycleTime = 1000;
    private long lastSystemTime;
    private int possibleIndex = 0;
    public int textColor = 0;
    private int cursorCycleTime = 500;
    public int drawXat;
    public double scc;
    public float[] boxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final ResourceLocation texture = new ResourceLocation("signpost:textures/gui/sign_gui.png");
    private FontRenderer fontRenderer;
    public String text = "";
    private final SignInput PARENT;

    public SignInputBox(FontRenderer p_i1032_1_, int x, int y, int width, SignInput parent) {
        this.fontRenderer = p_i1032_1_;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = (int)((double)width / 4.166666666666667);
        this.PARENT = parent;
        this.setText("");
        this.lastSystemTime = System.currentTimeMillis();
    }

    public void setFocused(boolean bool) {
        this.isFocused = bool;
        this.cursorPosition = this.getText().length();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void drawSignBox(FontRenderer fontRend) {
        this.fontRenderer = fontRend;
        GL11.glColor4f((float)this.boxColor[0], (float)this.boxColor[1], (float)this.boxColor[2], (float)this.boxColor[3]);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(texture);
        SignInputBox.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)137.5f, (float)33.0f);
        if (fontRend != null) {
            this.drawText();
        }
    }

    public void drawText() {
        String txt = this.drawCursor() && this.isFocused ? this.getText().substring(0, this.cursorPosition) + "|" + this.getText().substring(this.cursorPosition) : this.getText();
        double scale = (double)this.width / 25.0;
        double x = (double)this.x + (double)this.width / 2.0 - scale;
        double y = (double)this.y + (double)this.height / 2.0 + scale / 4.0;
        double sc2 = 100.0 / (double)this.fontRenderer.func_78256_a(txt);
        if (sc2 >= 1.0) {
            sc2 = 1.0;
        }
        this.scc = sc2;
        GL11.glPushMatrix();
        GL11.glScaled((double)sc2, (double)sc2, (double)1.0);
        if (sc2 == 1.0) {
            this.drawXat = (int)(x -= (double)this.fontRenderer.func_78256_a(txt) / 2.0);
        } else {
            this.drawXat = (int)(x - 50.0);
            x = (x - 50.0) / sc2;
        }
        this.fontRenderer.func_78276_b(txt, (int)x, (int)((y - (double)this.fontRenderer.field_78288_b / 2.0 * sc2) / sc2), this.textColor);
        GL11.glPopMatrix();
        if (this.isFocused && this.possible.size() > 0) {
            if (this.cycleTimeHasPassed()) {
                ++this.possibleIndex;
            }
            this.lastSystemTime = System.currentTimeMillis();
            this.possibleIndex %= this.possible.size();
            this.fontRenderer.func_78276_b(this.possible.get(this.possibleIndex), this.x + this.width + 5, (int)((double)this.y + (scale * 6.0 - (double)this.fontRenderer.field_78288_b) / 2.0), Color.WHITE.getRGB());
        }
    }

    private boolean drawCursor() {
        return System.currentTimeMillis() / (long)this.cursorCycleTime % 2L == 0L;
    }

    private boolean cycleTimeHasPassed() {
        return System.currentTimeMillis() % (long)this.cycleTime <= System.currentTimeMillis() - this.lastSystemTime;
    }

    public void setText(String text) {
        this.text = text;
        this.possible = new ArrayList();
        for (String name : SignInputBox.getAllPossibilities()) {
            if (!name.contains(this.getText()) && !this.getText().equals("")) continue;
            this.possible.add(name);
        }
    }

    public static Collection<String> getAllPossibilities() {
        return PostHandler.getAllWaystoneNames();
    }

    public String getText() {
        return this.text;
    }

    public boolean textboxKeyTyped(char p_146201_1_, int p_146201_2_) {
        if (!this.isFocused) {
            return false;
        }
        switch (p_146201_1_) {
            case '\u0001': {
                this.cursorPosition = this.getText().length();
                return true;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return true;
            }
        }
        switch (p_146201_2_) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                this.cursorPosition = 0;
                return true;
            }
            case 203: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                this.cursorPosition = this.getText().length();
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)p_146201_1_)) {
            this.writeText(Character.toString(p_146201_1_));
            return true;
        }
        return false;
    }

    public void writeText(String p_146191_1_) {
        String s2 = ChatAllowedCharacters.func_71565_a((String)p_146191_1_);
        this.setText(this.getText().substring(0, this.cursorPosition) + s2 + this.getText().substring(this.cursorPosition));
        this.moveCursorBy(s2.length());
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.cursorPosition + p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.getText().length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        } else if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.getText().length() != 0) {
            boolean flag = p_146175_1_ < 0;
            int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
            int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
            String s = "";
            if (j >= 0) {
                s = this.getText().substring(0, j);
            }
            if (k < this.getText().length()) {
                s = s + this.getText().substring(k);
            }
            this.setText(s);
            if (flag) {
                this.moveCursorBy(p_146175_1_);
            }
        }
    }

    public void deleteWords(int p_146177_1_) {
        if (this.getText().length() != 0) {
            this.deleteFromCursor(this.getNthWordFromCursor(p_146177_1_) - this.cursorPosition);
        }
    }

    public int getNthWordFromCursor(int p_146187_1_) {
        return this.getNthWordFromPos(p_146187_1_, this.cursorPosition);
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.func_146197_a(p_146183_1_, this.cursorPosition, true);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.getText().charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.getText().charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.getText().length();
            k = this.getText().indexOf(32, k);
            if (k == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.getText().charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void mouseClicked(int x, int y, int p_146192_3_) {
        this.isFocused = x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
        double scale = (double)this.width / 25.0;
        try {
            if (x >= this.x + this.width + 5 && x < this.x + this.width + 5 + this.fontRenderer.func_78256_a(this.possible.get(this.possibleIndex)) && (double)y >= (double)this.y + (scale * 6.0 - (double)this.fontRenderer.field_78288_b) / 2.0 && (double)y < (double)this.y + (scale * 6.0 - (double)this.fontRenderer.field_78288_b) / 2.0 + (double)this.fontRenderer.field_78288_b) {
                this.setText(this.possible.get(this.possibleIndex));
                this.PARENT.onTextChange(this);
                this.isFocused = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isFocused && p_146192_3_ == 0) {
            int l = x - this.drawXat;
            this.setCursorPosition(this.correctTrim((int)((double)l / this.scc)).length());
        }
    }

    public String correctTrim(int width) {
        int l2;
        int l = this.fontRenderer.func_78269_a(this.getText(), width).length();
        if (this.getText().length() == l) {
            return this.getText();
        }
        int l1 = this.fontRenderer.func_78256_a(this.getText().substring(0, l));
        if (width - l1 < (l2 = this.fontRenderer.func_78256_a(this.getText().substring(0, l + 1))) - width) {
            return this.getText().substring(0, l);
        }
        return this.getText().substring(0, l + 1);
    }

    public void setTextColor(int rgb) {
        this.textColor = rgb;
    }
}

