/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.ClientCommandHandler;
import mcjty.rftools.RFTools;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.EndergenicConfiguration;
import mcjty.rftools.blocks.endergen.EndergenicPearl;
import mcjty.rftools.blocks.endergen.GuiEndergenic;
import mcjty.rftools.hud.IHudSupport;
import mcjty.rftools.network.PacketGetHudLog;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EndergenicTileEntity
extends GenericEnergyStorageTileEntity
implements ITickable,
MachineInformation,
IHudSupport,
IMachineInformation,
TickOrderHandler.ICheckStateServer {
    private static Random random = new Random();
    public static final String CMD_GETSTATS = "getStats";
    public static Key<Long> PARAM_STATRF = new Key("statrf", Type.LONG);
    public static Key<Integer> PARAM_STATLOST = new Key("statlost", Type.INTEGER);
    public static Key<Integer> PARAM_STATLAUNCHED = new Key("statlaunched", Type.INTEGER);
    public static Key<Integer> PARAM_STATOPPORTUNITIES = new Key("statopportunities", Type.INTEGER);
    private static final String[] TAGS = new String[]{"rftick", "lost", "launched", "opportunities"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"Average RF/tick for the last 5 seconds", "Amount of pearls that were lost during the last 5 seconds", "Amount of pearls that were launched during the last 5 seconds", "Number of opportunities for the last 5 seconds"};
    public static final int CHARGE_IDLE = 0;
    public static final int CHARGE_HOLDING = -1;
    public static final Key<BlockPos> VALUE_DESTINATION = new Key("destination", Type.BLOCKPOS);
    private int chargingMode = 0;
    private int currentAge = 0;
    private BlockPos destination = null;
    private int distance = 0;
    private boolean prevIn = false;
    private long rfGained = 0L;
    private long rfLost = 0L;
    private int pearlsLaunched = 0;
    private int pearlsLost = 0;
    private int chargeCounter = 0;
    private int pearlArrivedAt = -2;
    private int ticks = 100;
    private long lastRfPerTick = 0L;
    private long lastRfGained = 0L;
    private long lastRfLost = 0L;
    private int lastPearlsLost = 0;
    private int lastPearlsLaunched = 0;
    private int lastChargeCounter = 0;
    private int lastPearlArrivedAt = 0;
    private String lastPearlsLostReason = "";
    private List<EndergenicPearl> pearls = new ArrayList<EndergenicPearl>();
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private int badCounter = 0;
    private int goodCounter = 0;
    private static long[] rfPerHit = new long[]{0L, 100L, 150L, 200L, 400L, 800L, 1600L, 3200L, 6400L, 8000L, 12800L, 8000L, 6400L, 2500L, 1000L, 100L};
    private int tickCounter = 0;
    public static final EnumFacing[] HORIZ_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_DESTINATION, this::getDestination, this::setDestination)};
    }

    public EndergenicTileEntity() {
        super(5000000L, 20000L);
    }

    public long getEnergyDiffPerTick() {
        return this.rfGained - this.rfLost;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return true;
    }

    public boolean isMachineRunning() {
        return true;
    }

    @Nullable
    public String getMachineStatus() {
        return null;
    }

    public void func_73660_a() {
        if (this.badCounter > 0) {
            --this.badCounter;
            this.markDirtyQuick();
        }
        if (this.goodCounter > 0) {
            --this.goodCounter;
            this.markDirtyQuick();
        }
        if (!this.func_145831_w().field_72995_K) {
            TickOrderHandler.queueEndergenic(this);
        }
    }

    @Override
    public EnumFacing getBlockOrientation() {
        return null;
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Last 5 seconds:");
        list.add("    Charged: " + this.getLastChargeCounter());
        list.add("    Fired: " + this.getLastPearlsLaunched());
        list.add("    Lost: " + this.getLastPearlsLost());
        if (this.getLastPearlsLost() > 0) {
            list.add(TextFormatting.RED + "    " + this.getLastPearlsLostReason());
        }
        if (this.getLastPearlArrivedAt() > -2) {
            list.add("    Last pearl at " + this.getLastPearlArrivedAt());
        }
        list.add(TextFormatting.BLUE + "Power:");
        list.add(TextFormatting.GREEN + "    RF Gain " + this.getLastRfGained());
        list.add(TextFormatting.RED + "    RF Lost " + this.getLastRfLost());
        list.add(TextFormatting.GREEN + "    RF/t " + this.getLastRfPerTick());
        return list;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    @Override
    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public int getBadCounter() {
        return this.badCounter;
    }

    public long getLastRfPerTick() {
        return this.lastRfPerTick;
    }

    public long getLastRfGained() {
        return this.lastRfGained;
    }

    public long getLastRfLost() {
        return this.lastRfLost;
    }

    public int getLastPearlsLost() {
        return this.lastPearlsLost;
    }

    public int getLastPearlsLaunched() {
        return this.lastPearlsLaunched;
    }

    public int getLastChargeCounter() {
        return this.lastChargeCounter;
    }

    public int getLastPearlArrivedAt() {
        return this.lastPearlArrivedAt;
    }

    public String getLastPearlsLostReason() {
        return this.lastPearlsLostReason;
    }

    public int getGoodCounter() {
        return this.goodCounter;
    }

    @Override
    public void checkStateServer() {
        ++this.tickCounter;
        --this.ticks;
        if (this.ticks < 0) {
            this.lastRfGained = this.rfGained;
            this.lastRfLost = this.rfLost;
            this.lastRfPerTick = (this.rfGained - this.rfLost) / 100L;
            this.lastPearlsLost = this.pearlsLost;
            this.lastPearlsLaunched = this.pearlsLaunched;
            this.lastChargeCounter = this.chargeCounter;
            this.lastPearlArrivedAt = this.pearlArrivedAt;
            this.ticks = 100;
            this.rfGained = 0L;
            this.rfLost = 0L;
            this.pearlsLaunched = 0;
            this.pearlsLost = 0;
            this.chargeCounter = 0;
            this.pearlArrivedAt = -2;
        }
        this.handlePearls();
        this.handleSendingEnergy();
        if (this.chargingMode == -1 && random.nextInt(1000) <= EndergenicConfiguration.chanceLost.get()) {
            this.log("Server Tick: discard pearl randomly");
            this.discardPearl("Random pearl discard");
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            if (this.chargingMode == 0) {
                this.log("Server Tick: pulse -> start charging");
                this.startCharging();
                return;
            }
            if (this.chargingMode == -1) {
                this.log("Server Tick: pulse -> fire pearl");
                this.firePearl();
                return;
            }
        }
        if (this.chargingMode == 0) {
            return;
        }
        if (this.chargingMode == -1) {
            long rf = EndergenicConfiguration.rfToHoldPearl.get();
            rf = (long)((float)rf * (3.0f - this.getInfusedFactor()) / 3.0f);
            long rfStored = this.getStoredPower();
            if (rfStored < rf) {
                this.log("Server Tick: insufficient energy to hold pearl (" + rfStored + " vs " + rf + ")");
                this.discardPearl("Not enough energy to hold pearl");
            } else {
                long rfExtracted = this.storage.extractEnergy(rf, false);
                this.log("Server Tick: holding pearl, consume " + rfExtracted + " RF");
                this.rfLost += rfExtracted;
            }
            return;
        }
        this.markDirtyQuick();
        ++this.chargingMode;
        if (this.chargingMode >= 16) {
            this.log("Server Tick: charging mode ends -> idle");
            this.chargingMode = 0;
        }
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.getDimension();
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return Long.toString(this.lastRfPerTick);
            }
            case 1: {
                return Integer.toString(this.lastPearlsLost);
            }
            case 2: {
                return Integer.toString(this.lastPearlsLaunched);
            }
            case 3: {
                return Integer.toString(this.lastChargeCounter);
            }
        }
        return null;
    }

    private void log(String message) {
    }

    private void fireMonitors(EnderMonitorMode mode) {
        BlockPos pos = this.func_174877_v();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            EnderMonitorTileEntity enderMonitorTileEntity;
            EnumFacing inputSide;
            BlockPos c = pos.func_177972_a(dir);
            TileEntity te = this.func_145831_w().func_175625_s(c);
            if (!(te instanceof EnderMonitorTileEntity) || (inputSide = (enderMonitorTileEntity = (EnderMonitorTileEntity)te).getFacing(this.func_145831_w().func_180495_p(c)).getInputSide()) != dir.func_176734_d()) continue;
            enderMonitorTileEntity.fireFromEndergenic(mode);
        }
    }

    private void handleSendingEnergy() {
        long energyAvailable = this.getStoredPower() - (long)EndergenicConfiguration.keepRfInBuffer.get();
        if (energyAvailable <= 0L) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            long rfToGive;
            long received;
            EnumFacing opposite;
            BlockPos o = this.func_174877_v().func_177972_a(dir);
            TileEntity te = this.func_145831_w().func_175625_s(o);
            if (EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)(opposite = dir.func_176734_d())) && (energyAvailable -= this.storage.extractEnergy(received = EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)(rfToGive = Math.min((long)EndergenicConfiguration.rfOutput.get(), energyAvailable))), false)) <= 0L) break;
        }
    }

    private void handlePearls() {
        if (this.pearls.isEmpty()) {
            return;
        }
        ArrayList<EndergenicPearl> newlist = new ArrayList<EndergenicPearl>();
        for (EndergenicPearl pearl : this.pearls) {
            this.log("Pearls: age=" + pearl.getAge() + ", ticks left=" + pearl.getTicksLeft());
            if (pearl.handleTick(this.func_145831_w())) continue;
            newlist.add(pearl);
        }
        this.pearls = newlist;
    }

    private void markDirtyClientNoRender() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175661_b(EntityPlayer.class, p -> this.func_174877_v().func_177954_c(p.field_70165_t, p.field_70163_u, p.field_70161_v) < 1024.0).stream().forEach(p -> RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSendClientCommand("rftools", "flashEndergenic", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.func_174877_v()).put(ClientCommandHandler.PARAM_GOODCOUNTER, (Object)this.goodCounter).put(ClientCommandHandler.PARAM_BADCOUNTER, (Object)this.badCounter).build()), (EntityPlayerMP)p));
        }
    }

    public void syncCountersFromServer(int goodCounter, int badCounter) {
        this.goodCounter = goodCounter;
        this.badCounter = badCounter;
    }

    private void discardPearl(String reason) {
        this.badCounter = 20;
        this.markDirtyClientNoRender();
        ++this.pearlsLost;
        this.lastPearlsLostReason = reason;
        this.chargingMode = 0;
        this.fireMonitors(EnderMonitorMode.MODE_LOSTPEARL);
    }

    public EndergenicTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.destination);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void firePearl() {
        this.markDirtyQuick();
        this.getDestinationTE();
        if (this.destination == null) {
            this.log("Fire Pearl: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            this.chargingMode = 0;
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, this.currentAge + 1));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void firePearlFromInjector() {
        this.markDirtyQuick();
        this.getDestinationTE();
        this.chargingMode = 0;
        if (this.destination == null) {
            this.log("Fire Pearl from injector: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl from injector: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, 0));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void receivePearl(int age) {
        this.fireMonitors(EnderMonitorMode.MODE_PEARLARRIVED);
        this.markDirtyQuick();
        if (this.chargingMode == -1) {
            this.log("Receive Pearl: pearl arrives but already holding -> both are lost");
            this.discardPearl("Pearl arrived while holding");
        } else if (this.chargingMode == 0) {
            this.log("Receive Pearl: pearl arrives but generator is idle -> pearl is lost");
            this.discardPearl("Pearl arrived while idle");
        } else {
            this.pearlArrivedAt = this.chargingMode;
            long rf = (long)((double)rfPerHit[this.chargingMode] * EndergenicConfiguration.powergenFactor.get());
            rf = (long)((float)rf * (this.getInfusedFactor() + 2.0f) / 2.0f);
            int a = age * 5;
            if (a > 100) {
                a = 100;
            }
            rf += rf * (long)a / 100L;
            this.rfGained += rf;
            this.log("Receive Pearl: pearl arrives at tick " + this.chargingMode + ", age=" + age + ", RF=" + rf);
            this.modifyEnergyStored(rf);
            this.goodCounter = 10;
            this.markDirtyClientNoRender();
            this.chargingMode = -1;
            this.currentAge = age;
        }
    }

    public void startCharging() {
        this.markDirtyQuick();
        this.chargingMode = 1;
        ++this.chargeCounter;
    }

    public void useWrench(EntityPlayer player) {
        BlockPos thisCoord = this.func_174877_v();
        BlockPos coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.func_145831_w().func_175625_s(coord);
        }
        if (!(tileEntity instanceof EndergenicTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(thisCoord);
            EndergenicTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
                Logging.message((EntityPlayer)player, (String)"Select another endergenic generator as destination");
            } else {
                RFTools.instance.clientInfo.setDestinationTE(destinationTE.func_174877_v());
                int distance = this.getDistanceInTicks();
                Logging.message((EntityPlayer)player, (String)("Select another endergenic generator as destination (current distance " + distance + ")"));
            }
        } else if (coord.equals((Object)thisCoord)) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
        } else {
            EndergenicTileEntity otherTE = (EndergenicTileEntity)tileEntity;
            int distance = otherTE.calculateDistance(thisCoord);
            if (distance >= 5) {
                Logging.warn((EntityPlayer)player, (String)"Distance is too far (maximum 4)");
                return;
            }
            otherTE.setDestination(thisCoord);
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            Logging.message((EntityPlayer)player, (String)("Destination is set (distance " + otherTE.getDistanceInTicks() + " ticks)"));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getChargingMode() {
        return this.chargingMode;
    }

    public int calculateDistance(BlockPos destination) {
        double d = new Vec3d((Vec3i)destination).func_72438_d(new Vec3d((Vec3i)this.func_174877_v()));
        return (int)(d / 3.0) + 1;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.markDirtyQuick();
        this.destination = destination;
        this.distance = this.calculateDistance(destination);
        if (this.func_145831_w().field_72995_K) {
            this.valueToServer(RFToolsMessages.INSTANCE, VALUE_DESTINATION, destination);
        }
    }

    public int getDistanceInTicks() {
        return this.distance;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargingMode = tagCompound.func_74762_e("charging");
        this.currentAge = tagCompound.func_74762_e("age");
        this.destination = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.distance = tagCompound.func_74762_e("distance");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.badCounter = tagCompound.func_74771_c("bad");
        this.goodCounter = tagCompound.func_74771_c("good");
        this.pearls.clear();
        NBTTagList list = tagCompound.func_150295_c("pearls", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            EndergenicPearl pearl = new EndergenicPearl(tc);
            this.pearls.add(pearl);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("charging", this.chargingMode);
        tagCompound.func_74768_a("age", this.currentAge);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74768_a("distance", this.distance);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74774_a("bad", (byte)this.badCounter);
        tagCompound.func_74774_a("good", (byte)this.goodCounter);
        NBTTagList pearlList = new NBTTagList();
        for (EndergenicPearl pearl : this.pearls) {
            pearlList.func_74742_a((NBTBase)pearl.getTagCompound());
        }
        tagCompound.func_74782_a("pearls", (NBTBase)pearlList);
        return tagCompound;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETSTATS.equals(command)) {
            return TypedMap.builder().put(PARAM_STATRF, (Object)this.lastRfPerTick).put(PARAM_STATLOST, (Object)this.lastPearlsLost).put(PARAM_STATLAUNCHED, (Object)this.lastPearlsLaunched).put(PARAM_STATOPPORTUNITIES, (Object)this.lastChargeCounter).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap value) {
        boolean rc = super.receiveDataFromServer(command, value);
        if (rc) {
            return true;
        }
        if (CMD_GETSTATS.equals(command)) {
            GuiEndergenic.fromServer_lastRfPerTick = (Long)value.get(PARAM_STATRF);
            GuiEndergenic.fromServer_lastPearlsLost = (Integer)value.get(PARAM_STATLOST);
            GuiEndergenic.fromServer_lastPearlsLaunched = (Integer)value.get(PARAM_STATLAUNCHED);
            GuiEndergenic.fromServer_lastPearlOpportunities = (Integer)value.get(PARAM_STATOPPORTUNITIES);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List list = super.executeWithResultList(command, args, type);
        if (!list.isEmpty()) {
            return list;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return list;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }

    public boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (world.field_72995_K) {
            SoundEvent pling = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.note.pling"));
            world.func_184133_a(player, pos, pling, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.useWrench(player);
        }
        return true;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        if (mode == ProbeMode.EXTENDED) {
            IItemStyle style = probeInfo.defaultItemStyle().width(16).height(13);
            ILayoutStyle layoutStyle = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
            probeInfo.text(TextFormatting.BLUE + "Stats over the last 5 seconds:");
            probeInfo.horizontal(layoutStyle).item(new ItemStack(Items.field_151137_ax), style).text("Charged " + this.getLastChargeCounter() + " time(s)");
            probeInfo.horizontal(layoutStyle).item(new ItemStack(Items.field_151079_bi), style).text("Fired " + this.getLastPearlsLaunched()).text(" / Lost " + this.getLastPearlsLost());
            if (this.getLastPearlsLost() > 0) {
                probeInfo.text(TextFormatting.RED + this.getLastPearlsLostReason());
            }
            if (this.getLastPearlArrivedAt() > -2) {
                probeInfo.text("Last pearl arrived at " + this.getLastPearlArrivedAt());
            }
            probeInfo.horizontal().text(TextFormatting.GREEN + "RF Gain " + this.getLastRfGained()).text(" / ").text(TextFormatting.RED + "Lost " + this.getLastRfLost()).text(" (RF/t " + this.getLastRfPerTick() + ")");
        } else {
            probeInfo.text("(sneak to get statistics)");
        }
    }
}

