/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.village;

import com.github.alexthe666.rats.server.world.gen.RatsVillageProcessor;
import com.github.alexthe666.rats.server.world.gen.WorldGenRatRuin;
import com.github.alexthe666.rats.server.world.village.VillageComponentGarbageHeap;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenGarbageHeap
extends WorldGenerator {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("rats", "village_garbage_heap");
    private VillageComponentGarbageHeap component;
    private Rotation rotation;
    private EnumFacing facing;

    public WorldGenGarbageHeap(VillageComponentGarbageHeap component, EnumFacing facing) {
        this.component = component;
        this.facing = facing;
        switch (facing) {
            case SOUTH: {
                this.rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                this.rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                this.rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                this.rotation = Rotation.NONE;
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn == null) {
            return false;
        }
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenRatRuin.getRotationFromFacing(this.facing)).func_186225_a(Blocks.field_150350_a);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        Biome biome = worldIn.func_180494_b(position);
        BlockPos genPos = position.func_177979_c(3).func_177967_a(this.facing, template.func_186259_a().func_177952_p()).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n());
        template.func_189960_a(worldIn, genPos, (ITemplateProcessor)new RatsVillageProcessor(position.func_177981_b(3), null, settings, biome), settings, 2);
        return true;
    }
}

