/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class RatsNuggetRegistry {
    public static Map<ItemStack, ItemStack> ORE_TO_INGOTS = new TreeMap<ItemStack, ItemStack>(new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            return o1.func_82833_r().compareTo(o2.func_82833_r());
        }
    });

    public static void init() {
        ItemStack stack;
        for (String oreName : OreDictionary.getOreNames()) {
            if (!oreName.contains("ore") || OreDictionary.getOres((String)oreName).isEmpty()) continue;
            stack = ItemStack.field_190927_a;
            try {
                stack = (ItemStack)OreDictionary.getOres((String)oreName).get(0);
            }
            catch (Exception e) {
                RatsMod.logger.warn("Could not make rat nugget for " + oreName);
            }
            ItemStack burntItem = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
            if (burntItem.func_190926_b()) continue;
            ORE_TO_INGOTS.put(stack, burntItem);
        }
        for (Map.Entry entry : ORE_TO_INGOTS.entrySet()) {
            ItemStack oreStack = (ItemStack)entry.getKey();
            ItemStack ingotStack = (ItemStack)entry.getValue();
            stack = new ItemStack(RatsItemRegistry.RAT_NUGGET_ORE, 1, RatsNuggetRegistry.getNuggetMeta(ingotStack));
            NBTTagCompound poopTag = new NBTTagCompound();
            NBTTagCompound oreTag = new NBTTagCompound();
            oreStack.func_77955_b(oreTag);
            NBTTagCompound ingotTag = new NBTTagCompound();
            ingotStack.func_77955_b(ingotTag);
            poopTag.func_74782_a("OreItem", (NBTBase)oreTag);
            poopTag.func_74782_a("IngotItem", (NBTBase)ingotTag);
            stack.func_77982_d(poopTag);
            GameRegistry.addSmelting((ItemStack)stack, (ItemStack)((ItemStack)entry.getValue()), (float)0.2f);
            OreDictionary.registerOre((String)"ratPoop", (ItemStack)stack);
        }
    }

    public static int getNuggetMeta(ItemStack ore) {
        int count = 0;
        for (Map.Entry<ItemStack, ItemStack> entry : ORE_TO_INGOTS.entrySet()) {
            if (entry.getValue().func_77969_a(ore)) break;
            ++count;
        }
        return count;
    }
}

