/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRatSack
extends Item {
    public ItemRatSack() {
        this.func_77655_b("rats.rat_sack");
        this.setRegistryName("rats", "rat_sack");
        this.func_77637_a(RatsMod.TAB);
        this.func_185043_a(new ResourceLocation("rat_count"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return Math.min(3, ItemRatSack.getRatsInStack(stack));
            }
        });
        this.func_77625_d(1);
    }

    public static int getRatsInStack(ItemStack stack) {
        int ratCount = 0;
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Rat")) continue;
                ++ratCount;
            }
        }
        return ratCount;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int f, boolean f1) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int ratCount = 0;
        ArrayList<String> ratNames = new ArrayList<String>();
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Rat")) continue;
                NBTTagCompound ratTag = stack.func_77978_p().func_74775_l(tagInfo);
                ++ratCount;
                String ratName = I18n.func_135052_a((String)"entity.rat.name", (Object[])new Object[0]);
                if (!ratTag.func_74779_i("CustomName").isEmpty()) {
                    ratName = ratTag.func_74779_i("CustomName");
                }
                ratNames.add(ratName);
            }
        }
        tooltip.add(I18n.func_135052_a((String)"item.rats.rat_sack.contains", (Object[])new Object[]{ratCount}));
        if (!ratNames.isEmpty()) {
            for (int i = 0; i < ratNames.size() && i < 3; ++i) {
                tooltip.add(I18n.func_135052_a((String)"item.rats.rat_sack.contain_rat", (Object[])new Object[]{ratNames.get(i)}));
            }
            if (ratNames.size() > 3) {
                tooltip.add(I18n.func_135052_a((String)"item.rats.rat_sack.and_more", (Object[])new Object[0]));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == RatsItemRegistry.RAT_SACK && ItemRatSack.getRatsInStack(stack) > 0) {
            int ratCount = 0;
            boolean flag = false;
            if (stack.func_77978_p() != null) {
                for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                    if (!tagInfo.contains("Rat")) continue;
                    ++ratCount;
                    NBTTagCompound ratTag = stack.func_77978_p().func_74775_l(tagInfo);
                    EntityRat rat = new EntityRat(worldIn);
                    BlockPos offset = pos.func_177972_a(facing);
                    rat.func_70037_a(ratTag);
                    rat.func_70012_b((double)offset.func_177958_n() + 0.5, offset.func_177956_o(), (double)offset.func_177952_p() + 0.5, 0.0f, 0.0f);
                    if (!worldIn.field_72995_K) {
                        worldIn.func_72838_d((Entity)rat);
                    }
                    flag = true;
                }
                stack.func_77982_d(new NBTTagCompound());
            }
            if (flag || ratCount > 0) {
                player.func_184609_a(hand);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("entity.rat.sack.release", new Object[]{ratCount}), true);
                stack.func_77982_d(new NBTTagCompound());
                player.func_184811_cZ().func_185145_a((Item)this, 10);
            }
        }
        return EnumActionResult.PASS;
    }

    public ItemStack onItemUseFinish(World worldIn, EntityLivingBase entityLiving) {
        return new ItemStack(RatsItemRegistry.RAT_SACK);
    }
}

