/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.pathfinding.AStar;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RatTubePathFinder
extends PathFinder {
    private final PathHeap path = new PathHeap();
    private final Set<PathPoint> closedSet = Sets.newHashSet();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;
    private EntityRat rat;

    public RatTubePathFinder(NodeProcessor processor, EntityRat rat) {
        super(processor);
        this.nodeProcessor = processor;
        this.rat = rat;
    }

    @Nullable
    public Path func_186333_a(IBlockAccess worldIn, EntityLiving entitylivingIn, Entity targetEntity, float maxDistance) {
        return this.findPath(worldIn, entitylivingIn, targetEntity.field_70165_t, targetEntity.func_174813_aQ().field_72338_b, targetEntity.field_70161_v, maxDistance);
    }

    @Nullable
    public Path func_186336_a(IBlockAccess worldIn, EntityLiving entitylivingIn, BlockPos targetPos, float maxDistance) {
        return this.findPath(worldIn, entitylivingIn, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, maxDistance);
    }

    @Nullable
    private Path findPath(IBlockAccess worldIn, EntityLiving entitylivingIn, double x, double y, double z, float maxDistance) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(worldIn, entitylivingIn);
        PathPoint pathpoint = this.nodeProcessor.func_186318_b();
        PathPoint pathpoint1 = this.nodeProcessor.func_186325_a(x, y, z);
        Path path = this.findPath(worldIn, pathpoint, pathpoint1, maxDistance);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(IBlockAccess worldIn, PathPoint pathFrom, PathPoint pathTo, float maxDistance) {
        BlockPos startPos = new BlockPos(pathFrom.field_75839_a, pathFrom.field_75837_b, pathFrom.field_75838_c);
        BlockPos endPos = new BlockPos(pathTo.field_75839_a, pathTo.field_75837_b, pathTo.field_75838_c);
        AStar aStar = new AStar(startPos, endPos, 1000, false);
        BlockPos[] pathBlocks = aStar.getPath(worldIn);
        PathPoint[] fromPos = new PathPoint[pathBlocks.length - 1];
        for (int i = 1; i < pathBlocks.length; ++i) {
            fromPos[i - 1] = new PathPoint(pathBlocks[i].func_177958_n(), pathBlocks[i].func_177956_o(), pathBlocks[i].func_177952_p());
        }
        return new Path(fromPos);
    }
}

