/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ai.RatAIMoveToBlock;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class RatAIRaidCrops
extends RatAIMoveToBlock {
    private final EntityRat entity;
    private boolean stop = false;

    public RatAIRaidCrops(EntityRat entity) {
        super((EntityCreature)entity, 1.0, entity.getSearchRadius());
        this.entity = entity;
    }

    public static boolean isCrops(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos.func_177984_a());
        return block.func_177230_c() instanceof BlockCrops;
    }

    @Override
    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.func_70909_n() || this.entity.isInCage() || !RatsMod.CONFIG_OPTIONS.ratsBreakCrops) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (this.runDelay <= 0 && !ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    @Override
    public void func_75246_d() {
        double distance;
        BlockPos cropsPos;
        IBlockState block;
        super.func_75246_d();
        if (this.getIsAboveDestination() && this.destinationBlock != null && (block = this.entity.field_70170_p.func_180495_p(cropsPos = this.destinationBlock.func_177984_a())).func_177230_c() instanceof BlockCrops && (distance = this.entity.func_70011_f(cropsPos.func_177958_n(), cropsPos.func_177956_o(), cropsPos.func_177952_p())) < 1.5) {
            ItemStack stack = new ItemStack(block.func_177230_c().func_180660_a(block, this.entity.func_70681_au(), 0));
            if (stack == ItemStack.field_190927_a || !this.entity.canRatPickupItem(stack)) {
                this.stop = true;
            } else {
                ItemStack duplicate = stack.func_77946_l();
                duplicate.func_190920_e(1);
                if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                    this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                }
                this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
                this.entity.field_70170_p.func_175655_b(cropsPos, false);
            }
            this.entity.fleePos = cropsPos;
            this.runDelay = 10;
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        return RatAIRaidCrops.isCrops(worldIn, pos);
    }
}

