/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityThrownBlock
extends Entity {
    public EntityLivingBase shootingEntity;
    public IBlockState fallTile;
    public boolean dropBlock = true;
    public NBTTagCompound tileEntityData;
    private int ticksAlive;
    private int ticksInAir;

    public EntityThrownBlock(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityThrownBlock(World worldIn, IBlockState blockState, EntityLivingBase entityNeoRatlantean) {
        super(worldIn);
        this.func_70105_a(0.98f, 0.98f);
        this.fallTile = blockState;
        this.shootingEntity = entityNeoRatlantean;
    }

    public static void registerFixesFireball(DataFixer fixer, String name) {
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shootingEntity == null || !this.shootingEntity.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            ++this.ticksInAir;
            if (this.ticksInAir > 25) {
                this.field_70145_X = true;
                RayTraceResult raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (this.ticksInAir >= 25 ? 1 : 0) != 0, (Entity)this.shootingEntity);
                if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onImpact(raytraceresult);
                }
            } else {
                this.field_70145_X = false;
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f = 0.8f;
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
            if (this.shootingEntity != null && this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null) {
                EntityLivingBase target = ((EntityLiving)this.shootingEntity).func_70638_az();
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70163_u - this.field_70163_u;
                double d2 = target.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += d0 / d3 * 0.2;
                this.field_70181_x += d1 / d3 * 0.2;
                this.field_70179_y += d2 / d3 * 0.2;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    public boolean canEntityBeSeen(Entity entityIn) {
        return this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(RayTraceResult result) {
        if (this.fallTile != null) {
            Block block = this.fallTile.func_177230_c();
            if (result != null && result.func_178782_a() != null) {
                for (Entity hitMobs : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
                    hitMobs.func_70097_a(DamageSource.field_76368_d, RatsMod.CONFIG_OPTIONS.neoRatlanteanAttack);
                }
                BlockPos blockpos1 = result.func_178782_a().func_177984_a();
                if (this.field_70170_p.func_190527_a(block, blockpos1, true, EnumFacing.UP, null)) {
                    TileEntity tileentity;
                    if (this.dropBlock) {
                        this.field_70170_p.func_175656_a(blockpos1, this.fallTile);
                    }
                    if (block instanceof BlockFalling) {
                        ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1, this.fallTile, this.fallTile);
                    }
                    if (this.tileEntityData != null && block.hasTileEntity(this.fallTile) && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                        NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                        for (String s : this.tileEntityData.func_150296_c()) {
                            NBTBase nbtbase = this.tileEntityData.func_74781_a(s);
                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                            nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                        }
                        tileentity.func_145839_a(nbttagcompound);
                        tileentity.func_70296_d();
                    }
                    this.func_70106_y();
                } else if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    if (!this.field_70170_p.field_72995_K && this.dropBlock) {
                        this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.fallTile)), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        compound.func_74768_a("life", this.ticksAlive);
        Block block = this.fallTile != null ? this.fallTile.func_177230_c() : Blocks.field_150350_a;
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        compound.func_74778_a("Block", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("Data", (byte)block.func_176201_c(this.fallTile));
        if (this.tileEntityData != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.tileEntityData);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("power", 9)) {
            NBTTagList nBTTagList = compound.func_150295_c("power", 6);
        }
        this.ticksAlive = compound.func_74762_e("life");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).func_74745_c() == 3) {
            NBTTagList nbttaglist1 = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist1.func_150309_d(0);
            this.field_70181_x = nbttaglist1.func_150309_d(1);
            this.field_70179_y = nbttaglist1.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
        int i = compound.func_74771_c("Data") & 0xFF;
        this.fallTile = compound.func_150297_b("Block", 8) ? Block.func_149684_b((String)compound.func_74779_i("Block")).func_176203_a(i) : (compound.func_150297_b("TileID", 99) ? Block.func_149729_e((int)compound.func_74762_e("TileID")).func_176203_a(i) : Block.func_149729_e((int)(compound.func_74771_c("Tile") & 0xFF)).func_176203_a(i));
        Block block = this.fallTile.func_177230_c();
        if (block == null || block.func_176223_P().func_185904_a() == Material.field_151579_a) {
            this.fallTile = Blocks.field_150349_c.func_176223_P();
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = compound.func_74775_l("TileEntityData");
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                this.field_70159_w = vec3d.field_72450_a;
                this.field_70181_x = vec3d.field_72448_b;
                this.field_70179_y = vec3d.field_72449_c;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)source.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

