/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityPiratBoat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.ai.PiratAIStrife;
import com.github.alexthe666.rats.server.entity.ai.PiratAIWander;
import com.github.alexthe666.rats.server.entity.ai.PiratPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatAIEnterTrap;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeSun;
import com.github.alexthe666.rats.server.entity.ai.RatAIHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAISit;
import com.github.alexthe666.rats.server.entity.ai.RatAIWander;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.base.Predicate;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityPirat
extends EntityRat
implements IRangedAttackMob,
IRatlantean,
IMob {
    private PiratAIStrife aiArrowAttack;
    private EntityAIAttackMelee aiAttackOnCollide;
    private int attackCooldown = 70;

    public EntityPirat(World worldIn) {
        super(worldIn);
        this.waterBased = true;
        Arrays.fill(this.field_184655_bs, 0.2f);
        Arrays.fill(this.field_82174_bp, 0.2f);
        this.field_70765_h = new PiratMoveHelper((EntityLiving)this);
        this.field_70699_by = new PiratPathNavigate((EntityLiving)this, this.field_70170_p);
    }

    public boolean func_70090_H() {
        return super.func_70090_H() && !this.func_184218_aH();
    }

    @Override
    protected void switchNavigator(int type) {
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiArrowAttack = new PiratAIStrife(this, 1.0, 20, 30.0f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.45, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new PiratAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new RatAIFleeSun(this, 1.66));
        this.field_70911_d = new RatAISit(this);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new RatAIEnterTrap(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 5, true, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return !(entity instanceof IRatlantean) && entity instanceof EntityLivingBase && !entity.func_184191_r((Entity)EntityPirat.this);
            }
        }));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new RatAIHurtByTarget(this, false, new Class[0]));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.setCombatTask();
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            if (this.func_184218_aH()) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.holdInMouth = false;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public double func_70033_W() {
        return 0.45;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setMale(this.func_70681_au().nextBoolean());
        this.setPlague(false);
        this.setToga(false);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(RatsItemRegistry.PIRAT_CUTLASS));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RatsItemRegistry.PIRAT_HAT));
        if (!this.func_184218_aH()) {
            EntityPiratBoat boat = new EntityPiratBoat(this.field_70170_p);
            boat.func_82149_j((Entity)this);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)boat);
            }
            this.func_184205_a((Entity)boat, true);
        }
        this.setCombatTask();
        return livingdata;
    }

    @Override
    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && iblockstate.func_185904_a() == Material.field_151586_h && this.field_70146_Z.nextFloat() < 0.1f;
    }

    @Override
    protected boolean isValidLightLevel() {
        BlockPos blockpos = this.field_70170_p.func_175645_m(new BlockPos(this.field_70165_t, 0.0, this.field_70161_v));
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    public boolean func_70909_n() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        boolean flag = super.func_184205_a(entityIn, force);
        this.setCombatTask();
        return flag;
    }

    public void func_184210_p() {
        super.func_184210_p();
        this.setCombatTask();
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityPiratBoat) {
            this.field_70171_ac = false;
        } else if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    @Override
    public void updateRiding(Entity riding) {
    }

    @Override
    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (!this.updateBlocked) {
                this.func_70071_h_();
            }
            if (this.func_184218_aH()) {
                entity.func_184232_k((Entity)this);
            }
        }
        this.field_70768_au = this.field_110154_aX;
        this.field_110154_aX = 0.0f;
        this.field_70143_R = 0.0f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.attackCooldown == 0) {
            this.func_70625_a((Entity)target, 180.0f, 180.0f);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d2 = target.field_70161_v - this.field_70161_v;
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = this.field_70177_z = f % 360.0f;
            Entity ridingEntity = this.func_184187_bx();
            if (ridingEntity instanceof EntityPiratBoat) {
                ((EntityPiratBoat)ridingEntity).shoot(this);
            }
            this.attackCooldown = 70;
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public boolean shouldHunt() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public static class PiratMoveHelper
    extends EntityMoveHelper {
        public PiratMoveHelper(EntityLiving entitylivingIn) {
            super(entitylivingIn);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.STRAFE) {
                PathNodeType type;
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigate pathnavigate = this.field_75648_a.func_70661_as();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.func_189566_q()) != null && (type = nodeprocessor.func_186330_a((IBlockAccess)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.field_70165_t + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.field_70163_u), MathHelper.func_76128_c((double)(this.field_75648_a.field_70161_v + (double)f8)))) != PathNodeType.WALKABLE && type != PathNodeType.WATER) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                this.field_75648_a.func_191989_p(this.field_75648_a.func_70689_ay());
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

