/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.compat.tinkers;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.compat.tinkers.TraitDisease;
import com.github.alexthe666.rats.server.compat.tinkers.TraitPlagueShot;
import com.github.alexthe666.rats.server.compat.tinkers.TraitRatty;
import com.github.alexthe666.rats.server.entity.EntityPlagueShot;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TinkersCompat {
    public static final Material CHEESE_MATERIAL = new Material("cheese", 15909170);
    public static final Material STRING_CHEESE = new Material("string_cheese", 15909170);
    public static final Material PLAGUE_METAL_MATERIAL = new Material("plague_metal", 5330000);
    public static final AbstractTrait RAT_TRAIT = new TraitRatty();
    public static final TraitPlagueShot PLAGUE_TRAIT = new TraitPlagueShot();
    public static final AbstractTrait DISEASED_TRAIT = new TraitDisease();
    private static final TinkersCompat INSTANCE = new TinkersCompat();
    private static boolean registered = false;

    public static void register() {
        if (registered) {
            throw new RuntimeException("You can only call TinkersCompat.register() once");
        }
        registered = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TinkersCompat.init();
    }

    public static void init() {
        TinkerMaterials.materials.add(CHEESE_MATERIAL);
        TinkerMaterials.materials.add(STRING_CHEESE);
        TinkerMaterials.materials.add(PLAGUE_METAL_MATERIAL);
        TinkerRegistry.integrate((Material)CHEESE_MATERIAL).preInit();
        TinkerRegistry.integrate((Material)STRING_CHEESE).preInit();
        TinkerRegistry.integrate((Material)PLAGUE_METAL_MATERIAL).preInit();
        CHEESE_MATERIAL.addTrait((ITrait)RAT_TRAIT);
        CHEESE_MATERIAL.addTrait((ITrait)TinkerTraits.tasty);
        CHEESE_MATERIAL.addItem("foodCheese", 1, 144);
        CHEESE_MATERIAL.addItem(RatsItemRegistry.CHEESE, 1, 144);
        CHEESE_MATERIAL.setRepresentativeItem(RatsItemRegistry.CHEESE);
        CHEESE_MATERIAL.setCraftable(true);
        CHEESE_MATERIAL.setCastable(false);
        TinkerRegistry.addMaterialStats((Material)CHEESE_MATERIAL, (IMaterialStats)new HeadMaterialStats(300, 4.0f, 2.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.5f, 40), new ExtraMaterialStats(150)});
        TinkerRegistry.addMaterialStats((Material)CHEESE_MATERIAL, (IMaterialStats)new BowMaterialStats(1.5f, 2.0f, -0.5f));
        STRING_CHEESE.addItem(RatsItemRegistry.STRING_CHEESE, 1, 144);
        STRING_CHEESE.setRepresentativeItem(RatsItemRegistry.STRING_CHEESE);
        BowStringMaterialStats bowstring = new BowStringMaterialStats(1.25f);
        TinkerRegistry.addMaterialStats((Material)STRING_CHEESE, (IMaterialStats)bowstring);
        PLAGUE_METAL_MATERIAL.addTrait((ITrait)DISEASED_TRAIT);
        PLAGUE_METAL_MATERIAL.addTrait((ITrait)PLAGUE_TRAIT);
        PLAGUE_METAL_MATERIAL.addItem(RatsItemRegistry.PLAGUE_ESSENCE, 1, 144);
        PLAGUE_METAL_MATERIAL.setRepresentativeItem(RatsItemRegistry.PLAGUE_ESSENCE);
        PLAGUE_METAL_MATERIAL.setCraftable(true);
        PLAGUE_METAL_MATERIAL.setCastable(false);
        TinkerRegistry.addMaterialStats((Material)PLAGUE_METAL_MATERIAL, (IMaterialStats)new HeadMaterialStats(780, 1.0f, 6.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.1f, -10), new ExtraMaterialStats(180)});
        TinkerRegistry.addMaterialStats((Material)PLAGUE_METAL_MATERIAL, (IMaterialStats)new BowMaterialStats(2.0f, 3.0f, 1.5f));
    }

    public static void post() {
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack(RatsBlockRegistry.BLOCK_OF_CHEESE), (Fluid)TinkerFluids.milk, 1000, RatsMod.CONFIG_OPTIONS.milkCauldronTime));
    }

    public static boolean onPlayerSwing(EntityLivingBase swinger, ItemStack stack) {
        if (PLAGUE_TRAIT.isToolWithTrait(stack)) {
            float totalDmg = ToolHelper.getActualDamage((ItemStack)stack, (EntityLivingBase)swinger);
            EntityPlagueShot shot = new EntityPlagueShot(swinger.field_70170_p, swinger, totalDmg * 0.5f);
            shot.func_184547_a((Entity)swinger, swinger.field_70125_A, swinger.field_70177_z, 0.0f, 0.8f, 1.0f);
            swinger.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
            if (!swinger.field_70170_p.field_72995_K) {
                swinger.field_70170_p.func_72838_d((Entity)shot);
            }
            return true;
        }
        return false;
    }
}

