/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.compat.jei;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.compat.jei.archeologist.ArcheologistRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.archeologist.ArcheologistRecipeHandler;
import com.github.alexthe666.rats.server.compat.jei.archeologist.ArcheologistRecipeWrapper;
import com.github.alexthe666.rats.server.compat.jei.cauldron.CauldronRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.cauldron.CauldronRecipeHandler;
import com.github.alexthe666.rats.server.compat.jei.cauldron.CauldronRecipeWrapper;
import com.github.alexthe666.rats.server.compat.jei.chef.ChefRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.chef.ChefRecipeHandler;
import com.github.alexthe666.rats.server.compat.jei.chef.ChefRecipeWrapper;
import com.github.alexthe666.rats.server.compat.jei.gemcutter.GemcutterRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.gemcutter.GemcutterRecipeHandler;
import com.github.alexthe666.rats.server.compat.jei.gemcutter.GemcutterRecipeWrapper;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.recipes.SharedRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class RatsJEIPlugin
implements IModPlugin {
    public static final String CAULDRON_ID = "rats.cauldron";
    public static final String CHEF_RAT_ID = "rats.chef_rat";
    public static final String ARCHEOLOGIST_RAT_ID = "rats.archeologist_rat";
    public static final String GEMCUTTER_RAT_ID = "rats.gemcutter_rat";

    private static void addDescription(IModRegistry registry, ItemStack stack) {
        registry.addIngredientInfo((Object)stack, ItemStack.class, new String[]{stack.func_77977_a() + ".jei_desc"});
    }

    public void register(IModRegistry registry) {
        if (RatsMod.CONFIG_OPTIONS.cheesemaking) {
            registry.addRecipes(RatsRecipeRegistry.CAULDRON_RECIPES, CAULDRON_ID);
            registry.addRecipeHandlers(new IRecipeHandler[]{new CauldronRecipeHandler()});
            registry.handleRecipes(SharedRecipe.class, (IRecipeWrapperFactory)new CauldronFactory(), CAULDRON_ID);
            registry.addRecipeCategoryCraftingItem(new ItemStack(Items.field_151066_bu), new String[]{CAULDRON_ID});
        }
        registry.addRecipes(RatsRecipeRegistry.RAT_CHEF_RECIPES, CHEF_RAT_ID);
        registry.addRecipeHandlers(new IRecipeHandler[]{new ChefRecipeHandler()});
        registry.handleRecipes(SharedRecipe.class, (IRecipeWrapperFactory)new ChefRatFactory(), CHEF_RAT_ID);
        registry.addRecipeCategoryCraftingItem(new ItemStack(RatsItemRegistry.RAT_UPGRADE_CHEF), new String[]{CHEF_RAT_ID});
        registry.addRecipes(RatsRecipeRegistry.RAT_ARCHEOLOGIST_RECIPES, ARCHEOLOGIST_RAT_ID);
        registry.addRecipeHandlers(new IRecipeHandler[]{new ArcheologistRecipeHandler()});
        registry.handleRecipes(SharedRecipe.class, (IRecipeWrapperFactory)new ArcheologistRatFactory(), ARCHEOLOGIST_RAT_ID);
        registry.addRecipeCategoryCraftingItem(new ItemStack(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST), new String[]{ARCHEOLOGIST_RAT_ID});
        registry.addRecipes(RatsRecipeRegistry.RAT_GEMCUTTER_RECIPES, GEMCUTTER_RAT_ID);
        registry.addRecipeHandlers(new IRecipeHandler[]{new GemcutterRecipeHandler()});
        registry.handleRecipes(SharedRecipe.class, (IRecipeWrapperFactory)new GemcutterRatFactory(), GEMCUTTER_RAT_ID);
        registry.addRecipeCategoryCraftingItem(new ItemStack(RatsItemRegistry.RAT_UPGRADE_GEMCUTTER), new String[]{GEMCUTTER_RAT_ID});
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.CHEESE));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.CHEESE_STICK));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_FLUTE));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_UPGRADE_BASIC));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_UPGRADE_CHEF));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_UPGRADE_WHITELIST));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsItemRegistry.RAT_UPGRADE_BLACKLIST));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsBlockRegistry.RAT_TRAP));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsBlockRegistry.RAT_CAGE));
        RatsJEIPlugin.addDescription(registry, new ItemStack(RatsBlockRegistry.RAT_CRAFTING_TABLE));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (RatsMod.CONFIG_OPTIONS.cheesemaking) {
            registry.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory()});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new ChefRecipeCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new ArcheologistRecipeCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new GemcutterRecipeCategory()});
    }

    public class GemcutterRatFactory
    implements IRecipeWrapperFactory<SharedRecipe> {
        public IRecipeWrapper getRecipeWrapper(SharedRecipe recipe) {
            return new GemcutterRecipeWrapper(recipe);
        }
    }

    public class ArcheologistRatFactory
    implements IRecipeWrapperFactory<SharedRecipe> {
        public IRecipeWrapper getRecipeWrapper(SharedRecipe recipe) {
            return new ArcheologistRecipeWrapper(recipe);
        }
    }

    public class ChefRatFactory
    implements IRecipeWrapperFactory<SharedRecipe> {
        public IRecipeWrapper getRecipeWrapper(SharedRecipe recipe) {
            return new ChefRecipeWrapper(recipe);
        }
    }

    public class CauldronFactory
    implements IRecipeWrapperFactory<SharedRecipe> {
        public IRecipeWrapper getRecipeWrapper(SharedRecipe recipe) {
            return new CauldronRecipeWrapper(recipe);
        }
    }
}

