/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCraftingTable;
import com.github.alexthe666.rats.server.inventory.ContainerRatCraftingTable;
import com.github.alexthe666.rats.server.message.MessageIncreaseRatRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class GuiRatCraftingTable
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/rat_crafting_table.png");
    private final InventoryPlayer playerInventory;
    private final IInventory tileFurnace;
    public ChangeCommandButton previousCommand;
    public ChangeCommandButton nextCommand;

    public GuiRatCraftingTable(IInventory furnaceInv, InventoryPlayer playerInv) {
        super((Container)new ContainerRatCraftingTable(furnaceInv, playerInv.field_70458_d));
        this.playerInventory = playerInv;
        this.tileFurnace = furnaceInv;
        this.field_147000_g = 211;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int i = (this.field_146294_l - 248) / 2;
        int j = (this.field_146295_m - 166) / 2;
        this.previousCommand = new ChangeCommandButton(1, i + 43, j + 56, false);
        this.field_146292_n.add(this.previousCommand);
        this.nextCommand = new ChangeCommandButton(2, i + 198, j + 56, true);
        this.field_146292_n.add(this.nextCommand);
    }

    protected void func_146284_a(GuiButton button) {
        TileEntityRatCraftingTable ratTable = (TileEntityRatCraftingTable)this.tileFurnace;
        if (button.field_146127_k == 1) {
            ratTable.decreaseRecipe();
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageIncreaseRatRecipe(((TileEntityRatCraftingTable)this.tileFurnace).func_174877_v().func_177986_g(), false));
        }
        if (button.field_146127_k == 2) {
            ratTable.increaseRecipe();
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageIncreaseRatRecipe(((TileEntityRatCraftingTable)this.tileFurnace).func_174877_v().func_177986_g(), true));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String ratDesc;
        String s = this.tileFurnace.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 5, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.rat_crafting_table.required", (Object[])new Object[0]), 8, this.field_147000_g - 163 + 2, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.rat_crafting_table.input", (Object[])new Object[0]), 8, this.field_147000_g - 123 + 2, 0x404040);
        int screenW = (this.field_146294_l - 248) / 2;
        int screenH = (this.field_146295_m - 166) / 2;
        ArrayList<ItemStack> drawnIngredients = new ArrayList<ItemStack>();
        if (this.tileFurnace instanceof TileEntityRatCraftingTable) {
            IRecipe recipe = ((TileEntityRatCraftingTable)this.tileFurnace).getSelectedRecipe();
            int renderingIndex = 0;
            if (recipe != null) {
                for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
                    Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
                    ItemStack[] matches = ingredient.func_193365_a();
                    int index = 0;
                    if (matches.length > 1) {
                        index = this.playerInventory.field_70458_d.field_70173_aa / 20 % matches.length;
                    }
                    if (matches.length <= 0) continue;
                    ItemStack drawn = matches[index].func_77946_l();
                    int count = 0;
                    if (this.doesListContainStack(drawnIngredients, drawn) || drawn.func_190926_b() || drawn.func_77973_b() == Items.field_190931_a) continue;
                    for (int j = 0; j < recipe.func_192400_c().size(); ++j) {
                        if (!this.doesArrayContainStack(((Ingredient)recipe.func_192400_c().get(j)).func_193365_a(), drawn)) continue;
                        ++count;
                    }
                    drawn.func_190920_e(count);
                    drawnIngredients.add(drawn);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179091_B();
                    this.drawRecipeItemStack(drawn, 8 + renderingIndex * 18, 60);
                    ++renderingIndex;
                }
            }
        }
        if (mouseX > screenW + 32 && mouseX < screenW + 70 && mouseY > screenH - 15 && mouseY < screenH + 24) {
            ratDesc = I18n.func_135052_a((String)"container.rat_crafting_table.rat_desc", (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(ratDesc), (int)(mouseX - screenW - 40), (int)(mouseY - screenH + 10), (int)this.field_146294_l, (int)this.field_146295_m, (int)120, (FontRenderer)this.field_146289_q);
        }
        if (mouseX > screenW + 69 && mouseX < screenW + 87 && mouseY > screenH - 7 && mouseY < screenH + 15 && this.tileFurnace.func_70301_a(0).func_190926_b()) {
            ratDesc = I18n.func_135052_a((String)"container.rat_crafting_table.input_desc", (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(ratDesc), (int)(mouseX - screenW - 40), (int)(mouseY - screenH + 10), (int)this.field_146294_l, (int)this.field_146295_m, (int)120, (FontRenderer)this.field_146289_q);
        }
    }

    private boolean doesListContainStack(List<ItemStack> list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)currentItem, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean doesArrayContainStack(ItemStack[] list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)currentItem, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void drawRecipeItemStack(ItemStack stack, int x, int y) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, null);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = this.getCookProgressScaled(64);
        this.func_73729_b(i + 54, j + 21, 0, 211, l, 16);
        if (((TileEntityRatCraftingTable)this.tileFurnace).hasRat) {
            this.func_73729_b(i + 9, j, 176, 0, 21, 21);
        } else {
            this.func_73729_b(i + 8, j + 15, 198, 0, 21, 21);
        }
    }

    private int getCookProgressScaled(int pixels) {
        int i = this.tileFurnace.func_174887_a_(0);
        int j = 200;
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public boolean shouldRenderButtons() {
        return ((TileEntityRatCraftingTable)this.tileFurnace).hasMultipleRecipes();
    }
}

