/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;

public class PacketGSISavedDataPacket
implements IMessage {
    public NBTTagCompound SAVE_TAG;
    public int GSI_IDENTITY = -1;
    public DisplayGSISaveHandler.DisplayGSISavedData saveType;

    public PacketGSISavedDataPacket() {
    }

    public PacketGSISavedDataPacket(DisplayGSI gsi, DisplayGSISaveHandler.DisplayGSISavedData saveType) {
        this.GSI_IDENTITY = gsi.getDisplayGSIIdentity();
        this.SAVE_TAG = DisplayGSISaveHandler.writeGSIData(gsi, new NBTTagCompound(), NBTHelper.SyncType.SAVE, saveType);
        this.saveType = saveType;
    }

    public void fromBytes(ByteBuf buf) {
        this.GSI_IDENTITY = buf.readInt();
        this.SAVE_TAG = ByteBufUtils.readTag((ByteBuf)buf);
        this.saveType = DisplayGSISaveHandler.DisplayGSISavedData.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.GSI_IDENTITY);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.SAVE_TAG);
        buf.writeInt(this.saveType.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketGSISavedDataPacket, IMessage> {
        public IMessage onMessage(PacketGSISavedDataPacket message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    DisplayGSI gsi;
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player != null && (gsi = ClientInfoHandler.instance().getGSIMap().get(message.GSI_IDENTITY)) != null) {
                        DisplayGSISaveHandler.readGSIData(gsi, message.SAVE_TAG, NBTHelper.SyncType.SAVE, message.saveType);
                        gsi.validate();
                    }
                });
            }
            return null;
        }
    }
}

