/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;

public class PacketGSIConnectedDisplayValidate
implements IMessage {
    public NBTTagCompound SAVE_TAG;
    public int DISPLAY_ID = -1;
    public int GSI_IDENTITY = -1;

    public PacketGSIConnectedDisplayValidate() {
    }

    public PacketGSIConnectedDisplayValidate(DisplayGSI gsi, IDisplay display) {
        this.GSI_IDENTITY = gsi.getDisplayGSIIdentity();
        this.SAVE_TAG = gsi.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE);
        this.DISPLAY_ID = display.getIdentity();
    }

    public void fromBytes(ByteBuf buf) {
        this.GSI_IDENTITY = buf.readInt();
        this.SAVE_TAG = ByteBufUtils.readTag((ByteBuf)buf);
        this.DISPLAY_ID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.GSI_IDENTITY);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.SAVE_TAG);
        buf.writeInt(this.DISPLAY_ID);
    }

    public static class Handler
    implements IMessageHandler<PacketGSIConnectedDisplayValidate, IMessage> {
        public IMessage onMessage(PacketGSIConnectedDisplayValidate message, MessageContext ctx) {
            EntityPlayer player;
            if (ctx.side == Side.CLIENT && (player = SonarCore.proxy.getPlayerEntity(ctx)) != null) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    DisplayGSI gsi;
                    IDisplay display = ClientInfoHandler.instance().getConnectedDisplays().get(message.DISPLAY_ID);
                    DisplayGSI displayGSI = gsi = display == null ? null : display.getGSI();
                    if (display == null || gsi == null) {
                        ClientInfoHandler.instance().invalid_gsi.put(message.GSI_IDENTITY, message.SAVE_TAG);
                        return;
                    }
                    gsi.readData(message.SAVE_TAG, NBTHelper.SyncType.SAVE);
                    gsi.validate();
                });
            }
            return null;
        }
    }
}

