/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.base.filters.IFilteredTile;
import sonar.logistics.base.filters.INodeFilter;
import sonar.logistics.base.utils.ListPacket;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;
import sonar.logistics.network.sync.SyncFilterList;

public class PacketNodeFilter
extends PacketMultipart {
    public INodeFilter filter;
    public ListPacket packetType;

    public PacketNodeFilter() {
    }

    public PacketNodeFilter(int slotID, BlockPos pos, ListPacket packetType) {
        super(slotID, pos);
        this.packetType = packetType;
    }

    public PacketNodeFilter(int slotID, BlockPos pos, ListPacket packetType, INodeFilter filter) {
        super(slotID, pos);
        this.filter = filter;
        this.packetType = packetType;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.filter = InfoHelper.readFilterFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.packetType = ListPacket.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.filter != null);
        if (this.filter != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)InfoHelper.writeFilterToNBT(new NBTTagCompound(), this.filter, NBTHelper.SyncType.SAVE));
        }
        buf.writeInt(this.packetType.ordinal());
    }

    public static class Handler
    extends PacketMultipartHandler<PacketNodeFilter> {
        public IMessage processMessage(PacketNodeFilter message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (player == null || player.func_130014_f_().field_72995_K || !(part instanceof IFilteredTile)) {
                return null;
            }
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                IFilteredTile tile = (IFilteredTile)part;
                SyncFilterList filters = tile.getFilters();
                switch (message.packetType) {
                    case ADD: {
                        for (INodeFilter filter : filters.getObjects()) {
                            if (!filter.equals(message.filter)) continue;
                            filter.readData(message.filter.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE), NBTHelper.SyncType.SAVE);
                            filters.markChanged();
                            return;
                        }
                        filters.addObject(message.filter);
                        break;
                    }
                    case MOVE_DOWN: {
                        int listPos = -1;
                        for (int i = 0; i < filters.objs.size(); ++i) {
                            INodeFilter filter = filters.getObjects().get(i);
                            if (!filter.equals(message.filter)) continue;
                            listPos = i;
                        }
                        if (listPos + 1 <= 0 || listPos + 1 >= filters.objs.size()) break;
                        Collections.swap(filters.objs, listPos, listPos + 1);
                        filters.markChanged();
                        break;
                    }
                    case MOVE_UP: {
                        int listPos = -1;
                        for (int i = 0; i < filters.objs.size(); ++i) {
                            INodeFilter filter = filters.getObjects().get(i);
                            if (!filter.equals(message.filter)) continue;
                            listPos = i;
                        }
                        if (listPos - 1 < 0 || listPos - 1 >= filters.objs.size()) break;
                        Collections.swap(filters.objs, listPos, listPos - 1);
                        filters.markChanged();
                        break;
                    }
                    case REMOVE: {
                        filters.removeObject(message.filter);
                        break;
                    }
                    case CLEAR: {
                        filters.objs.clear();
                        filters.markChanged();
                        break;
                    }
                }
            });
            return null;
        }
    }
}

