/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.receivers;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.overlays.OverlayBlockSelection;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.wireless.receivers.ContainerAbstractReceiver;
import sonar.logistics.core.tiles.wireless.receivers.TileAbstractReceiver;

public abstract class GuiAbstractReceiver
extends GuiSelectionList<ClientWirelessEmitter> {
    public TileAbstractReceiver tile;

    public GuiAbstractReceiver(TileAbstractReceiver tileDataReceiver) {
        super((Container)new ContainerAbstractReceiver(tileDataReceiver), tileDataReceiver);
        this.tile = tileDataReceiver;
        this.field_146999_f = 248;
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, ClientWirelessEmitter info) {
        if (buttonID == 0) {
            this.tile.selectedEmitter.setObject((INBTSyncable)info);
            this.tile.sendByteBufPacket(0);
        } else {
            OverlayBlockSelection.addPosition(info.coords.getCoords(), false);
        }
    }

    @Override
    public boolean isCategoryHeader(ClientWirelessEmitter info) {
        if (!OverlayBlockSelection.positions.isEmpty()) {
            return OverlayBlockSelection.isPositionRenderered(info.coords.getCoords());
        }
        return false;
    }

    @Override
    public boolean isSelectedInfo(ClientWirelessEmitter info) {
        return this.tile.clientEmitters.getObjects().contains(info);
    }

    @Override
    public void renderInfo(ClientWirelessEmitter info, int yPos) {
        int colour = PL2Colours.white_text.getRGB();
        FontHelper.text((String)((String)info.name.getObject()), (int)InfoRenderHelper.left_offset, (int)yPos, (int)colour);
        FontHelper.text((String)info.coords.getCoords().toString(), (int)173, (int)yPos, (int)colour);
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(ClientWirelessEmitter info) {
        return false;
    }
}

