/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.handling;

import java.util.List;
import sonar.core.listener.ISonarListener;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionType;
import sonar.logistics.api.core.tiles.wireless.emitters.IRedstoneEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IRedstoneReceiver;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHandler;
import sonar.logistics.core.tiles.wireless.handling.AbstractWirelessManager;

public class WirelessRedstoneManager
extends AbstractWirelessManager<IRedstoneNetwork, IRedstoneEmitter, IRedstoneReceiver> {
    public static WirelessRedstoneManager instance() {
        return PL2.proxy.wirelessRedstoneManager;
    }

    @Override
    public EnumWirelessConnectionType type() {
        return EnumWirelessConnectionType.REDSTONE;
    }

    public void connectNetworks(IRedstoneNetwork watcher, IRedstoneNetwork connected) {
        if (watcher.isValid() && connected.isValid()) {
            watcher.getListenerList().addListener((ISonarListener)connected, new int[]{0});
            connected.getListenerList().addListener((ISonarListener)watcher, new int[]{1});
            watcher.markCablesChanged();
        }
    }

    public void disconnectNetworks(IRedstoneNetwork watcher, IRedstoneNetwork connected) {
        if (watcher.isValid() && connected.isValid()) {
            watcher.getListenerList().removeListener((ISonarListener)connected, true, new int[]{0});
            connected.getListenerList().removeListener((ISonarListener)watcher, true, new int[]{1});
            watcher.markCablesChanged();
        }
    }

    @Override
    public void onReceiverConnected(IRedstoneNetwork main, IRedstoneReceiver receiver) {
        receiver.refreshConnectedNetworks();
        List<Integer> connected = receiver.getConnectedNetworks();
        connected.iterator().forEachRemaining(networkID -> {
            IRedstoneNetwork sub = RedstoneConnectionHandler.instance().getNetwork((int)networkID);
            if (sub.getNetworkID() != main.getNetworkID() && sub.isValid()) {
                this.connectNetworks(main, sub);
            }
        });
    }

    @Override
    public void onReceiverDisconnected(IRedstoneNetwork network, IRedstoneReceiver receiver) {
        receiver.refreshConnectedNetworks();
        List<Integer> connected = receiver.getConnectedNetworks();
        connected.iterator().forEachRemaining(networkID -> {
            IRedstoneNetwork sub = RedstoneConnectionHandler.instance().getNetwork((int)networkID);
            if (sub.getNetworkID() != network.getNetworkID() && sub.isValid()) {
                this.disconnectNetworks(network, sub);
            }
        });
    }
}

