/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.fluids.handling;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import sonar.core.api.SonarAPI;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.utils.ActionType;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidHelper;

public class DummyFluidHandler
implements IFluidHandler,
IFluidTankProperties {
    public ILogisticsNetwork network;
    public StoredFluidStack fluid;

    public DummyFluidHandler(ILogisticsNetwork network, StoredFluidStack fluid) {
        this.network = network;
        this.fluid = fluid;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public int fill(FluidStack resource, boolean doFill) {
        StoredFluidStack toFill = new StoredFluidStack(resource);
        StoredFluidStack stack = FluidHelper.transferFluids(this.network, toFill.copy(), NodeTransferMode.ADD, ActionType.getTypeForAction((!doFill ? 1 : 0) != 0), null);
        StoredFluidStack returned = SonarAPI.getFluidHelper().getStackToAdd((long)resource.amount, toFill, stack);
        return returned == null ? 0 : returned.getFullStack().amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        StoredFluidStack toDrain = new StoredFluidStack(resource);
        StoredFluidStack stack = FluidHelper.transferFluids(this.network, toDrain.copy(), NodeTransferMode.REMOVE, ActionType.getTypeForAction((!doDrain ? 1 : 0) != 0), null);
        StoredFluidStack returned = SonarAPI.getFluidHelper().getStackToAdd((long)resource.amount, toDrain, stack);
        return returned == null ? null : returned.getFullStack();
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        StoredFluidStack toDrain = new StoredFluidStack(this.fluid.getFullStack(), (long)maxDrain, (long)maxDrain);
        StoredFluidStack stack = FluidHelper.transferFluids(this.network, toDrain.copy(), NodeTransferMode.REMOVE, ActionType.getTypeForAction((!doDrain ? 1 : 0) != 0), null);
        StoredFluidStack returned = SonarAPI.getFluidHelper().getStackToAdd((long)maxDrain, toDrain, stack);
        return returned == null ? null : returned.getFullStack();
    }

    public FluidStack getContents() {
        return this.fluid == null ? null : this.fluid.getFullStack();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.fluid == null ? Integer.MAX_VALUE : this.fluid.capacity);
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return this.fluid != null && this.fluid.stored > 0L;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.fluid == null || this.fluid.equalStack(fluidStack);
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.fluid != null && this.fluid.equalStack(fluidStack);
    }
}

