/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.fluids;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.StorageSize;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.ContainerChannelSelection;
import sonar.logistics.base.channels.GuiChannelSelection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidChangeableList;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.displays.info.types.progress.InfoProgressBar;
import sonar.logistics.core.tiles.readers.base.TileAbstractListReader;
import sonar.logistics.core.tiles.readers.fluids.ContainerFluidReader;
import sonar.logistics.core.tiles.readers.fluids.FluidReader;
import sonar.logistics.core.tiles.readers.fluids.FluidSorter;
import sonar.logistics.core.tiles.readers.fluids.GuiFluidReader;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidNetworkChannels;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidNetworkHandler;
import sonar.logistics.network.sync.SyncMonitoredType;

public class TileFluidReader
extends TileAbstractListReader<InfoNetworkFluid>
implements IByteBufTile {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK, ErrorMessage.NO_FLUID_SELECTED};
    public SyncMonitoredType<InfoNetworkFluid> selected = new SyncMonitoredType(1);
    public SyncEnum<FluidReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])FluidReader.Modes.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT targetSlot = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 5).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<FluidReader.SortingType> sortingType = (SyncEnum)new SyncEnum((Enum[])FluidReader.SortingType.values(), 6).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public FluidSorter fluid_sorter = new FluidSorter(){

        @Override
        public SortingDirection getDirection() {
            return (SortingDirection)TileFluidReader.this.sortingOrder.getObject();
        }

        @Override
        public FluidReader.SortingType getType() {
            return (FluidReader.SortingType)TileFluidReader.this.sortingType.getObject();
        }
    };
    public boolean sorting_changed = true;

    public TileFluidReader() {
        this.syncList.addParts(new IDirtyPart[]{this.setting, this.targetSlot, this.posSlot, this.sortingOrder, this.sortingType, this.selected});
    }

    @Override
    public List<INetworkHandler> addValidHandlers(List<INetworkHandler> handlers) {
        handlers.add(FluidNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public int getMaxInfo() {
        return 1;
    }

    @Override
    public AbstractChangeableList<InfoNetworkFluid> getViewableList(AbstractChangeableList<InfoNetworkFluid> updateList, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<InfoNetworkFluid>> channels, List<NodeConnection> usedChannels) {
        if (updateList instanceof FluidChangeableList) {
            channels.values().forEach(list -> {
                if (list instanceof FluidChangeableList) {
                    ((FluidChangeableList)updateList).sizing.add(((FluidChangeableList)list).sizing);
                }
            });
        }
        return super.getViewableList(updateList, uuid, channels, usedChannels);
    }

    @Override
    public AbstractChangeableList<InfoNetworkFluid> sortMonitoredList(AbstractChangeableList<InfoNetworkFluid> updateInfo, int channelID) {
        return this.fluid_sorter.sortSaveableList(updateInfo);
    }

    @Override
    public void setMonitoredInfo(AbstractChangeableList<InfoNetworkFluid> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        INameableInfo<LogicInfoList> info = null;
        switch ((FluidReader.Modes)this.setting.getObject()) {
            case SELECTED: {
                InfoNetworkFluid stack = this.selected.getMonitoredInfo();
                if (stack == null || !stack.isValid()) break;
                stack.getStoredStack().setStackSize(0L);
                InfoNetworkFluid dummyInfo = new InfoNetworkFluid(stack.getStoredStack().copy(), this.network.getNetworkID());
                IMonitoredValue<InfoNetworkFluid> value = updateInfo.find(dummyInfo);
                info = value == null ? dummyInfo : new InfoNetworkFluid(value.getSaveableInfo().getStoredStack().copy(), this.network.getNetworkID());
                break;
            }
            case POS: {
                break;
            }
            case STORAGE: {
                StorageSize size = updateInfo instanceof FluidChangeableList ? ((FluidChangeableList)updateInfo).sizing : new StorageSize(0L, 0L);
                info = new InfoProgressBar(LogicInfo.buildDirectInfo("fluid.storage", RegistryType.TILE, size.getStored()), LogicInfo.buildDirectInfo("max", RegistryType.TILE, size.getMaxStored()));
                break;
            }
            case TANKS: {
                LogicInfoList list = new LogicInfoList(this.getIdentity(), "fluid", this.getNetworkID());
                list.listSorter = this.fluid_sorter;
                info = list;
                break;
            }
        }
        ServerInfoHandler.instance().changeInfo(this, uuid, info);
        if (this.sorting_changed) {
            ServerInfoHandler.instance().markChanged(this, uuid);
            this.sorting_changed = false;
        }
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        FluidNetworkChannels list;
        super.readPacket(buf, id);
        if (id == this.sortingOrder.id || id == this.sortingType.id) {
            this.sorting_changed = true;
        }
        if ((id == 5 || id == 6) && (list = this.network.getNetworkChannels(FluidNetworkChannels.class)) != null) {
            List players = this.listeners.getListeners(new Enum[]{ListenerType.OLD_GUI_LISTENER});
            players.forEach(player -> list.sendLocalRapidUpdate(this, (EntityPlayer)player.player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerFluidReader(this, player);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiFluidReader(this, player);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
        }
        return null;
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public ILogicListSorter getSorter() {
        return this.fluid_sorter;
    }
}

