/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.fluids;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.asm.ASMListSorter;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidCount;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.readers.SortingHelper;
import sonar.logistics.core.tiles.readers.fluids.FluidReader;

@ASMListSorter(id="fluid_sorter", modid="practicallogistics2")
public class FluidSorter
implements ILogicListSorter<InfoNetworkFluid> {
    public SortingDirection direction;
    public FluidReader.SortingType sorting_type;
    public static final String REGISTRY_NAME = "fluid_sorter";

    public FluidSorter() {
    }

    public FluidSorter(SortingDirection direction, FluidReader.SortingType type) {
        this.direction = direction;
        this.sorting_type = type;
    }

    @Override
    public boolean canSort(Object obj) {
        return obj instanceof FluidCount || obj instanceof InfoNetworkFluid;
    }

    @Override
    public AbstractChangeableList<InfoNetworkFluid> sortSaveableList(AbstractChangeableList<InfoNetworkFluid> updateInfo) {
        return SortingHelper.sortFluids(updateInfo, this.getDirection(), this.getType());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.direction = SortingDirection.values()[nbt.func_74762_e("SdiD")];
        this.sorting_type = FluidReader.SortingType.values()[nbt.func_74762_e("StiD")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("SdiD", this.getDirection().ordinal());
        nbt.func_74768_a("StiD", this.getType().ordinal());
        return nbt;
    }

    public SortingDirection getDirection() {
        return this.direction;
    }

    public FluidReader.SortingType getType() {
        return this.sorting_type;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

