/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.energy;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.asm.ASMListSorter;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.core.tiles.displays.info.types.energy.MonitoredEnergyStack;
import sonar.logistics.core.tiles.readers.SortingHelper;
import sonar.logistics.core.tiles.readers.energy.EnergyReader;

@ASMListSorter(id="energy_sorter", modid="practicallogistics2")
public class EnergySorter
implements ILogicListSorter<MonitoredEnergyStack> {
    public SortingDirection direction;
    public EnergyReader.SortingType sorting_type;
    public static final String REGISTRY_NAME = "energy_sorter";

    public EnergySorter() {
    }

    public EnergySorter(SortingDirection direction, EnergyReader.SortingType type) {
        this.direction = direction;
        this.sorting_type = type;
    }

    @Override
    public boolean canSort(Object obj) {
        return obj instanceof IMonitoredValue && ((IMonitoredValue)obj).getSaveableInfo() instanceof MonitoredEnergyStack || obj instanceof MonitoredEnergyStack;
    }

    @Override
    public AbstractChangeableList<MonitoredEnergyStack> sortSaveableList(AbstractChangeableList<MonitoredEnergyStack> updateInfo) {
        return SortingHelper.sortEnergy(updateInfo, this.getDirection(), this.getType());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.direction = SortingDirection.values()[nbt.func_74762_e("SdiD")];
        this.sorting_type = EnergyReader.SortingType.values()[nbt.func_74762_e("StiD")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("SdiD", this.getDirection().ordinal());
        nbt.func_74768_a("StiD", this.getType().ordinal());
        return nbt;
    }

    public SortingDirection getDirection() {
        return this.direction;
    }

    public EnergyReader.SortingType getType() {
        return this.sorting_type;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

