/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes.transfer.handling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sonar.core.handlers.inventories.handling.ITransferMethod;
import sonar.core.handlers.inventories.handling.ItemTransferHandler;
import sonar.core.handlers.inventories.handling.methods.TransferMethodSimple;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.handling.DefaultNetworkChannels;
import sonar.logistics.base.filters.ITransferFilteredTile;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;

public class TransferNetworkChannels<M extends IInfo, H extends INetworkHandler>
extends DefaultNetworkChannels {
    private List<ITransferFilteredTile> nodes = new ArrayList<ITransferFilteredTile>();
    private Iterator<ITransferFilteredTile> nodeIterator;
    private int nodesPerTick = 0;
    private ItemTransferHandler handler = new ItemTransferHandler();

    public TransferNetworkChannels(ILogisticsNetwork network) {
        super(network, CacheHandler.TRANSFER_NODES);
        this.handler.setMethod((ITransferMethod)new TransferMethodSimple(this.handler).setTransferRate(128));
        this.handler.setFilter(IS -> !IS.func_190926_b());
    }

    @Override
    public int getUpdateRate() {
        return 20;
    }

    @Override
    public void onCreated() {
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.nodes.clear();
        this.nodeIterator = null;
    }

    @Override
    protected void tickChannels() {
        super.tickChannels();
        this.nodesPerTick = this.nodes.size() > this.getUpdateRate() ? (int)Math.ceil(this.nodes.size() / Math.max(1, this.getUpdateRate())) : 1;
        this.nodeIterator = this.nodes.iterator();
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        this.handler.transfer();
    }

    @Override
    public void addConnection(INetworkTile connection) {
        if (!this.nodes.contains(connection) && this.nodes.add((ITransferFilteredTile)connection)) {
            this.onChannelsChanged();
            this.tickChannels();
            BlockConnection block = ((ITransferFilteredTile)connection).getConnected();
            if (((ITransferFilteredTile)connection).getTransferMode().shouldRemove()) {
                // empty if block
            }
        }
    }

    @Override
    public void removeConnection(INetworkTile connection) {
        if (this.nodes.remove(connection)) {
            this.onChannelsChanged();
            this.tickChannels();
        }
    }

    private void updateTransferNodes(List<NodeConnection> allChannels) {
    }
}

