/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.common.block.properties.SonarProperties;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.PL2Properties;
import sonar.logistics.core.tiles.base.BlockLogisticsSided;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.nodes.TileRedstoneNode;

public class BlockRedstoneNode
extends BlockLogisticsSided {
    public BlockRedstoneNode() {
        super(PL2Multiparts.REDSTONE_NODE);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (!tile.func_145831_w().field_72995_K && tile instanceof TileRedstoneNode) {
            TileRedstoneNode node = (TileRedstoneNode)tile;
            if (node.isSelfChecking) {
                return 0;
            }
        }
        if (side == ((EnumFacing)state.func_177229_b((IProperty)SonarProperties.ORIENTATION)).func_176734_d()) {
            return (Boolean)RedstoneConnectionHelper.getCableState(world, pos).func_177229_b((IProperty)PL2Properties.ACTIVE) != false ? 15 : 0;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return ((EnumFacing)state.func_177229_b((IProperty)SonarProperties.ORIENTATION)).func_176734_d() == side;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(facing.func_176734_d().ordinal());
    }

    @Override
    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumFaceSlot.fromFace((EnumFacing)facing.func_176734_d());
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        int power = this.func_180656_a(state, world, pos, ((EnumFacing)state.func_177229_b((IProperty)SonarProperties.ORIENTATION)).func_176734_d());
        if (power == 0 && (tile = world.func_175625_s(pos)) instanceof TileRedstoneNode) {
            power = ((TileRedstoneNode)tile).getCurrentPower();
        }
        return state.func_177226_a((IProperty)PL2Properties.ACTIVE, (Comparable)Boolean.valueOf(power > 0));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SonarProperties.ORIENTATION, PL2Properties.ACTIVE});
    }
}

