/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.holographic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;
import sonar.logistics.network.packets.PacketHolographicDisplayScaling;

public class TileAdvancedHolographicDisplay
extends TileAbstractHolographicDisplay {
    public Vec3d screenScale = new Vec3d(1.0, 1.0, 0.001);
    public Vec3d screenRotation = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d screenOffset = new Vec3d(0.0, 0.0, 0.0);
    public boolean defaults_set = false;

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            this.defaults_set = nbt.func_74767_n("defs");
            this.screenScale = DisplayVectorHelper.readVec3d("scale", nbt, type);
            this.screenRotation = DisplayVectorHelper.readVec3d("rotate", nbt, type);
            this.screenOffset = DisplayVectorHelper.readVec3d("offset", nbt, type);
            if (this.isClient() && this.func_145831_w() != null) {
                this.getHolographicEntity().ifPresent(entity -> entity.setSizingFromDisplay(this));
            }
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            this.updateDefaultScaling();
            nbt.func_74757_a("defs", this.defaults_set);
            DisplayVectorHelper.writeVec3d(this.screenScale, "scale", nbt, type);
            DisplayVectorHelper.writeVec3d(this.screenRotation, "rotate", nbt, type);
            DisplayVectorHelper.writeVec3d(this.screenOffset, "offset", nbt, type);
        }
        return super.writeData(nbt, type);
    }

    @Override
    public Vec3d getScreenScaling() {
        return this.screenScale;
    }

    public void setScaling(double width, double height, double depth) {
        this.screenScale = new Vec3d(width, height, depth);
        this.func_70296_d();
    }

    @Override
    public Vec3d getScreenRotation() {
        return this.screenRotation;
    }

    public void setRotation(double pitch, double yaw, double roll) {
        this.screenRotation = new Vec3d(pitch, yaw, roll);
        this.func_70296_d();
    }

    @Override
    public Vec3d getScreenOffset() {
        return this.screenOffset;
    }

    public void setScreenOffset(double x, double y, double z) {
        this.screenOffset = new Vec3d(x, y, z);
        this.func_70296_d();
    }

    @Override
    public void doAdditionEvent(PL2AdditionType type) {
        super.doAdditionEvent(type);
        this.updateDefaultScaling();
    }

    public void updateDefaultScaling() {
        if (this.isServer() && !this.defaults_set) {
            this.screenOffset = DisplayVectorHelper.getFaceOffset(this.getCableFace(), 0.5);
            this.screenRotation = DisplayVectorHelper.getScreenRotation(this.getCableFace());
            this.defaults_set = true;
            this.func_70296_d();
        }
    }

    @Override
    public void sendPropertiesToServer() {
        if (this.isClient()) {
            PL2.network.sendToServer((IMessage)new PacketHolographicDisplayScaling(this));
        }
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.HALF;
    }
}

