/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles;

import javax.annotation.Nonnull;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.properties.SonarProperties;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.core.tiles.base.BlockLogisticsSided;
import sonar.logistics.core.tiles.displays.DisplayHelper;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;

public class BlockAbstractDisplay
extends BlockLogisticsSided {
    public BlockAbstractDisplay(PL2Multiparts multipart) {
        super(multipart);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.field_178784_b == state.func_177229_b((IProperty)SonarProperties.ORIENTATION)) {
            return true;
        }
        return super.addHitEffects(state, world, target, manager);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing[] orientation = DisplayHelper.getScreenOrientation(placer, facing);
        return this.func_176203_a(orientation[0].ordinal());
    }

    @Override
    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        EnumFacing[] orientation = DisplayHelper.getScreenOrientation(placer, facing);
        return EnumDisplayFaceSlot.fromFace(orientation[0]);
    }

    @Override
    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return EnumDisplayFaceSlot.fromFace(this.getOrientation(state));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAbstractDisplay) {
            TileAbstractDisplay display = (TileAbstractDisplay)tile;
            if (display.getGSI() == null) {
                return false;
            }
            if (facing != state.func_177229_b((IProperty)SonarProperties.ORIENTATION)) {
                if (!world.field_72995_K && this.canOpenGui(player)) {
                    display.openFlexibleGui(player, 0);
                }
            } else {
                if (display instanceof TileAbstractHolographicDisplay) {
                    display.openFlexibleGui(player, 2);
                    return true;
                }
                return display.getGSI().onClicked(display, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            }
        }
        return true;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing rotation = EnumFacing.NORTH;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAbstractDisplay) {
            // empty if block
        }
        return state.func_177226_a((IProperty)SonarProperties.ROTATION, (Comparable)rotation);
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SonarProperties.ORIENTATION, SonarProperties.ROTATION});
    }
}

