/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledInfo;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringHelper;
import sonar.logistics.core.tiles.displays.info.types.text.utils.TextSelection;

public class StyledStringFormatter {
    public static void formatTextSelections(StyledTextElement text, List<TextSelection> selections, BiFunction<Integer, IStyledString, IStyledString> formatter) {
        for (TextSelection select : selections) {
            for (int y = select.startY; y <= select.endY; ++y) {
                StyledStringLine c = text.getLine(y);
                if (c == null) continue;
                int[] subSelect = select.getSubStringSize(c.getCachedUnformattedString(), y);
                int start = subSelect[0];
                int end = subSelect[1];
                if (start == -1 || end == -1) continue;
                ArrayList<IStyledString> formatted_strings = new ArrayList<IStyledString>();
                int index_count = 0;
                for (IStyledString ss : c.getStrings()) {
                    int subStart = Math.max(index_count, start) - index_count;
                    int subEnd = Math.min(index_count + ss.getStringLength(), end) - index_count;
                    if (subStart >= 0 && subStart < subEnd) {
                        if (ss instanceof StyledInfo) {
                            StyledStringHelper.addWithCombine(formatted_strings, formatter.apply(y, ss.copy()));
                        } else {
                            String[] subStrings = StyledStringHelper.getSubStrings(subStart, subEnd, ss.getUnformattedString());
                            StyledStringHelper.addWithCombine(formatted_strings, new StyledString(subStrings[0], ss.getStyle().copy()));
                            StyledStringHelper.addWithCombine(formatted_strings, formatter.apply(y, new StyledString(subStrings[1], ss.getStyle().copy())));
                            StyledStringHelper.addWithCombine(formatted_strings, new StyledString(subStrings[2], ss.getStyle().copy()));
                        }
                    } else {
                        StyledStringHelper.addWithCombine(formatted_strings, ss);
                    }
                    index_count += ss.getStringLength();
                }
                c.setStrings(formatted_strings);
            }
        }
        if (text.getLines().isEmpty()) {
            text.addNewLine(0, new StyledStringLine(text, ""));
        }
    }

    public static void formatSelectedLines(StyledTextElement text, List<TextSelection> selections, Function<StyledStringLine, StyledStringLine> formatter) {
        HashMap<Integer, StyledStringLine> lines = new HashMap<Integer, StyledStringLine>();
        for (TextSelection select : selections) {
            for (int y = select.startY; y <= select.endY; ++y) {
                StyledStringLine c = text.getLine(y);
                if (c == null) continue;
                lines.put(y, c);
            }
        }
        ArrayList<StyledStringLine> toRemove = new ArrayList<StyledStringLine>();
        for (Map.Entry line : lines.entrySet()) {
            StyledStringLine newLine = formatter.apply((StyledStringLine)line.getValue());
            if (newLine == null) {
                toRemove.add(text.getLines().get((Integer)line.getKey()));
                continue;
            }
            text.setLine((Integer)line.getKey(), newLine);
        }
        for (StyledStringLine line : toRemove) {
            if (line == null) continue;
            text.getLines().remove(line);
        }
    }
}

