/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.utils;

import com.google.common.collect.Lists;
import java.util.List;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.CursorPosition;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringFormatter;
import sonar.logistics.core.tiles.displays.info.types.text.utils.TextSelection;

public class StyledStringEditor {
    public static void addStyledStrings(StyledTextElement text, CursorPosition cursorPosition, List<IStyledString> strings) {
        if (cursorPosition.validPosition()) {
            StyledStringLine newLine = new StyledStringLine(text);
            if (cursorPosition.x != 0) {
                TextSelection before = new TextSelection(0, cursorPosition.x, cursorPosition.y, cursorPosition.y);
                StyledStringFormatter.formatTextSelections(text, Lists.newArrayList((Object[])new TextSelection[]{before}), (line, ss) -> {
                    newLine.addWithCombine((IStyledString)ss);
                    return ss;
                });
            }
            strings.forEach(newLine::addWithCombine);
            if (cursorPosition.x != text.getLineLength(cursorPosition.y)) {
                TextSelection after = new TextSelection(cursorPosition.x, Integer.MAX_VALUE, cursorPosition.y, cursorPosition.y);
                StyledStringFormatter.formatTextSelections(text, Lists.newArrayList((Object[])new TextSelection[]{after}), (line, ss) -> {
                    newLine.addWithCombine((IStyledString)ss);
                    return ss;
                });
            }
            text.setLine(cursorPosition.y, newLine);
        }
    }

    public static void addStyledLines(StyledTextElement text, CursorPosition cursorPosition, List<StyledStringLine> lines, boolean combineFirst) {
        if (cursorPosition.validPosition()) {
            boolean combinedFirst;
            int yPos = cursorPosition.y;
            StyledStringLine beforeLine = new StyledStringLine(text);
            boolean bl = combinedFirst = cursorPosition.x == 0 || !combineFirst;
            if (cursorPosition.x != 0) {
                TextSelection before = new TextSelection(0, cursorPosition.x, cursorPosition.y, cursorPosition.y);
                StyledStringFormatter.formatTextSelections(text, Lists.newArrayList((Object[])new TextSelection[]{before}), (line, ss) -> {
                    beforeLine.addWithCombine((IStyledString)ss);
                    return ss;
                });
                text.addNewLine(yPos, beforeLine);
                ++yPos;
            }
            StyledStringLine afterLines = new StyledStringLine(text);
            if (cursorPosition.x != text.getLineLength(cursorPosition.y)) {
                TextSelection after = new TextSelection(cursorPosition.x, Integer.MAX_VALUE, cursorPosition.y, cursorPosition.y);
                StyledStringFormatter.formatTextSelections(text, Lists.newArrayList((Object[])new TextSelection[]{after}), (line, ss) -> {
                    afterLines.addWithCombine((IStyledString)ss);
                    return ss;
                });
            }
            for (StyledStringLine line2 : lines) {
                if (!combinedFirst) {
                    line2.getStrings().forEach(beforeLine::addWithCombine);
                    combinedFirst = true;
                    continue;
                }
                text.addNewLine(yPos, line2);
                ++yPos;
            }
            if (!afterLines.getStrings().isEmpty()) {
                text.addNewLine(yPos, afterLines);
                ++yPos;
            }
        }
    }
}

