/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.styling;

import javax.xml.ws.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMStyledString;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.SonarStyling;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

@ASMStyledString(id="s_s", modid="practicallogistics2")
public class StyledString
implements IStyledString,
INBTSyncable {
    public String string;
    private SonarStyling style;
    private String formattingString;
    private StyledStringLine line;
    private String cachedFormattedString = null;
    private int cachedWidth = -1;
    public static final String REGISTRY_NAME = "s_s";

    public StyledString() {
    }

    public StyledString(String string) {
        this(string, new SonarStyling());
    }

    public StyledString(String string, SonarStyling style) {
        this.string = string;
        this.style = style;
    }

    @Override
    public IStyledString setLine(StyledStringLine line) {
        this.line = line;
        return this;
    }

    @Override
    public StyledStringLine getLine() {
        return this.line;
    }

    @Override
    public String setUnformattedString(String s) {
        this.string = s;
        this.updateTextContents();
        return this.getUnformattedString();
    }

    @Override
    public String getUnformattedString() {
        return this.string;
    }

    @Override
    public String getTextFormattingStyle() {
        return this.style.getTextFormattingString();
    }

    @Override
    public String getFormattedString() {
        if (this.cachedFormattedString == null) {
            this.cachedFormattedString = this.getTextFormattingStyle() + this.getUnformattedString();
        }
        return this.cachedFormattedString;
    }

    @Override
    public SonarStyling setStyle(SonarStyling f) {
        this.style = f;
        this.onStyleChanged();
        return this.getStyle();
    }

    @Override
    public SonarStyling getStyle() {
        return this.style;
    }

    public String toString() {
        return this.getFormattedString();
    }

    @Override
    public void onStyleChanged() {
        this.updateTextContents();
    }

    @Override
    public void updateTextContents() {
        this.cachedWidth = -1;
        this.cachedFormattedString = null;
        if (this.getLine() != null) {
            this.getLine().updateTextContents();
        }
    }

    @Override
    public void updateTextScaling() {
        if (this.getLine() != null) {
            this.getLine().updateTextScaling();
        }
    }

    @Override
    public int getStringLength() {
        return this.getUnformattedString().length();
    }

    @Override
    public int getStringWidth() {
        if (this.cachedWidth == -1) {
            this.cachedWidth = RenderHelper.fontRenderer.func_78256_a(this.getFormattedString());
        }
        return this.cachedWidth;
    }

    @Override
    public IStyledString copy() {
        return new StyledString(this.string, this.style.copy());
    }

    @Override
    public Tuple<Character, Integer> getCharClicked(int yPos, Holder<Double> subClickX, Holder<Double> subClickY) {
        double[] scaling = DisplayElementHelper.getScaling(this.getText().getUnscaledWidthHeight(), this.getText().getMaxScaling(), 100.0);
        String unformatted = this.getUnformattedString();
        String formatting = this.getTextFormattingStyle();
        int length = unformatted.length();
        double x = 0.0;
        for (int i = 0; i < length; ++i) {
            String charString = formatting + unformatted.charAt(i);
            int charStringWidth = RenderHelper.fontRenderer.func_78256_a(charString);
            double width = (double)charStringWidth * scaling[2];
            if (x <= (Double)subClickX.value && x + width >= (Double)subClickX.value) {
                subClickX.value = x;
                return new Tuple((Object)Character.valueOf(unformatted.charAt(i)), (Object)i);
            }
            if (i == 0 && (Double)subClickX.value < x) {
                return new Tuple(null, (Object)-2);
            }
            x += width;
        }
        return new Tuple(null, (Object)-1);
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.string = nbt.func_74779_i("s");
        this.style = new SonarStyling();
        this.style.readData(nbt, type);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74778_a("s", this.string);
        this.style.writeData(nbt, type);
        return nbt;
    }

    @Override
    public boolean canCombine(IStyledString ss) {
        return ss instanceof StyledString && ss.getStyle().matching(this.style);
    }

    @Override
    public void combine(IStyledString ss) {
        int previousLength = this.getStringLength();
        this.setUnformattedString(this.getUnformattedString() + ss.getUnformattedString());
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

