/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.styling;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.ws.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMStyledString;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.info.references.ReferenceType;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.SonarStyling;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

@ASMStyledString(id="s_i", modid="practicallogistics2")
public class StyledInfo
implements IStyledString,
INBTSyncable {
    public InfoUUID uuid;
    public ReferenceType refType;
    public SonarStyling style;
    private static final char REPRESENTIVE = '^';
    private String formattingString;
    private StyledStringLine line;
    private String cachedFormattedString = null;
    private int cachedWidth = -1;
    public static final String REGISTRY_NAME = "s_i";

    public StyledInfo() {
    }

    public StyledInfo(InfoUUID uuid, ReferenceType type) {
        this(uuid, type, new SonarStyling());
    }

    public StyledInfo(InfoUUID uuid, ReferenceType refType, SonarStyling style) {
        this.uuid = uuid;
        this.refType = refType;
        this.style = style;
    }

    @Override
    public IStyledString setLine(StyledStringLine line) {
        this.line = line;
        return this;
    }

    @Override
    public StyledStringLine getLine() {
        return this.line;
    }

    public InfoUUID getInfoUUID() {
        return this.uuid;
    }

    public InfoUUID setInfoUUID(InfoUUID uuid) {
        this.uuid = uuid;
        return this.uuid;
    }

    public ReferenceType getReferenceType() {
        return this.refType;
    }

    public ReferenceType setReferenceType(ReferenceType refType) {
        this.refType = refType;
        return this.refType;
    }

    @Override
    public String setUnformattedString(String s) {
        return s;
    }

    @Override
    public String getUnformattedString() {
        return String.valueOf('^');
    }

    @Override
    public String getTextFormattingStyle() {
        return this.style.getTextFormattingString();
    }

    @Override
    public String getFormattedString() {
        if (this.cachedFormattedString == null) {
            this.cachedFormattedString = this.getTextFormattingStyle() + this.refType.getRefString(ClientInfoHandler.instance().getInfoMap().get(this.uuid));
        }
        return this.cachedFormattedString;
    }

    @Override
    public SonarStyling setStyle(SonarStyling f) {
        this.style = f;
        this.onStyleChanged();
        return this.getStyle();
    }

    @Override
    public SonarStyling getStyle() {
        return this.style;
    }

    @Override
    public void onStyleChanged() {
        this.updateTextContents();
    }

    @Override
    public void updateTextContents() {
        this.cachedWidth = -1;
        this.cachedFormattedString = null;
        if (this.getLine() != null) {
            this.getLine().updateTextContents();
        }
    }

    @Override
    public void updateTextScaling() {
        if (this.getLine() != null) {
            this.getLine().updateTextScaling();
        }
    }

    public String toString() {
        return this.getFormattedString();
    }

    @Override
    public int getStringLength() {
        return this.getUnformattedString().length();
    }

    @Override
    public int getStringWidth() {
        if (this.cachedWidth == -1) {
            this.cachedWidth = RenderHelper.fontRenderer.func_78256_a(this.getFormattedString());
        }
        return this.cachedWidth;
    }

    @Override
    public IStyledString copy() {
        return new StyledInfo(this.uuid, this.refType, this.style.copy());
    }

    @Override
    public Tuple<Character, Integer> getCharClicked(int yPos, Holder<Double> subClickX, Holder<Double> subClickY) {
        return new Tuple((Object)Character.valueOf('^'), (Object)0);
    }

    @Override
    public List<InfoUUID> getInfoReferences() {
        return Lists.newArrayList((Object[])new InfoUUID[]{this.uuid});
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.uuid = new InfoUUID();
        this.uuid.readData(nbt, type);
        this.style = new SonarStyling();
        this.style.readData(nbt, type);
        this.refType = ReferenceType.values()[nbt.func_74762_e("rt")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.uuid.writeData(nbt, type);
        this.style.writeData(nbt, type);
        nbt.func_74768_a("rt", this.refType.ordinal());
        return nbt;
    }

    @Override
    public boolean canCombine(IStyledString ss) {
        return false;
    }

    @Override
    public void combine(IStyledString ss) {
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

