/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.styling;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;

public class SonarStyling
implements INBTSyncable {
    public int rgb = -1;
    public int bgd = -1;
    public int action_id = -1;
    public boolean bold = false;
    public boolean italic = false;
    public boolean underlined = false;
    public boolean strikethrough = false;
    public boolean obfuscated = false;

    public SonarStyling copy() {
        SonarStyling style = new SonarStyling();
        style.rgb = this.rgb;
        style.bgd = this.bgd;
        style.bold = this.bold;
        style.italic = this.italic;
        style.underlined = this.underlined;
        style.strikethrough = this.strikethrough;
        style.obfuscated = this.obfuscated;
        style.action_id = this.action_id;
        return style;
    }

    public void setFontColour(int colour) {
        this.rgb = colour;
    }

    public int getFontColour() {
        return this.rgb;
    }

    public void setBackgroundColour(int colour) {
        this.bgd = colour;
    }

    public int getBackgroundColour() {
        return this.bgd;
    }

    public void setActionID(int actionID) {
        this.action_id = actionID;
    }

    public int getActionID() {
        return this.action_id;
    }

    public String getTextFormattingString() {
        StringBuilder s = new StringBuilder();
        if (this.bold) {
            s.append(TextFormatting.BOLD);
        }
        if (this.italic) {
            s.append(TextFormatting.ITALIC);
        }
        if (this.underlined) {
            s.append(TextFormatting.UNDERLINE);
        }
        if (this.strikethrough) {
            s.append(TextFormatting.STRIKETHROUGH);
        }
        if (this.obfuscated) {
            s.append(TextFormatting.OBFUSCATED);
        }
        return s.toString();
    }

    public void toggleSpecialFormatting(List<TextFormatting> formatting, boolean enable) {
        for (TextFormatting format : formatting) {
            if (!format.func_96301_b()) continue;
            switch (format) {
                case BOLD: {
                    this.bold = enable;
                    break;
                }
                case ITALIC: {
                    this.italic = enable;
                    break;
                }
                case UNDERLINE: {
                    this.underlined = enable;
                    break;
                }
                case STRIKETHROUGH: {
                    this.strikethrough = enable;
                    break;
                }
                case OBFUSCATED: {
                    this.obfuscated = enable;
                    break;
                }
            }
        }
    }

    public boolean needsSave() {
        return this.rgb != -1 || this.bgd != -1 || this.bold || this.italic || this.underlined || this.strikethrough || this.obfuscated;
    }

    public boolean matching(SonarStyling ss) {
        int[] colour = this.getIntFormatting();
        int[] compareColour = ss.getIntFormatting();
        for (int i = 0; i < colour.length; ++i) {
            if (colour[i] == compareColour[i]) continue;
            return false;
        }
        byte[] format = this.getByteFormatting();
        byte[] compareFormat = ss.getByteFormatting();
        for (int f = 0; f < format.length; ++f) {
            if (format[f] == compareFormat[f]) continue;
            return false;
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (!nbt.func_74767_n("def")) {
            this.fromIntFormatting(nbt.func_74759_k("c"));
            this.fromByteFormatting(nbt.func_74770_j("f"));
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        boolean save = this.needsSave();
        nbt.func_74757_a("def", !save);
        if (save) {
            nbt.func_74783_a("c", this.getIntFormatting());
            nbt.func_74773_a("f", this.getByteFormatting());
        }
        return nbt;
    }

    public int[] getIntFormatting() {
        int[] colours = new int[]{this.rgb, this.bgd, this.action_id};
        return colours;
    }

    public void fromIntFormatting(int[] colours) {
        if (colours.length != 3) {
            return;
        }
        this.rgb = colours[0];
        this.bgd = colours[1];
        this.action_id = colours[2];
    }

    public byte[] getByteFormatting() {
        byte[] format = new byte[]{(byte)(this.bold ? 1 : 0), (byte)(this.italic ? 1 : 0), (byte)(this.underlined ? 1 : 0), (byte)(this.strikethrough ? 1 : 0), (byte)(this.obfuscated ? 1 : 0)};
        return format;
    }

    public void fromByteFormatting(byte[] format) {
        if (format.length != 5) {
            return;
        }
        this.bold = format[0] == 1;
        this.italic = format[1] == 1;
        this.underlined = format[2] == 1;
        this.strikethrough = format[3] == 1;
        this.obfuscated = format[4] == 1;
    }
}

