/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.items;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.StoredItemStack;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.core.tiles.displays.info.types.items.ItemCount;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;

public class ItemChangeableList
extends AbstractChangeableList<MonitoredItemStack> {
    public StorageSize sizing = new StorageSize(0L, 0L);

    public static ItemChangeableList newChangeableList() {
        return new ItemChangeableList();
    }

    public ItemCount createMonitoredValue(MonitoredItemStack obj) {
        return new ItemCount(obj);
    }

    @Override
    public void saveStates() {
        super.saveStates();
        this.sizing = new StorageSize(0L, 0L);
    }

    @Override
    public void add(StoredItemStack stack) {
        ItemCount found = this.find(stack.item);
        if (found == null) {
            this.values.add(this.createMonitoredValue(new MonitoredItemStack(stack)));
        } else {
            found.combine(stack.stored);
        }
    }

    public void add(ItemStack stack, long stored, long maxStored) {
        ItemCount found = this.find(stack);
        if (found == null) {
            this.values.add(this.createMonitoredValue(new MonitoredItemStack(new StoredItemStack(stack, stored))));
        } else {
            found.combine(stored);
        }
        this.sizing.add(stored);
        this.sizing.addToMax(maxStored);
    }

    @Nullable
    public ItemCount find(ItemStack obj) {
        for (IMonitoredValue value : this.values) {
            ItemCount count = (ItemCount)value;
            if (!count.canCombine(obj)) continue;
            return count;
        }
        return null;
    }

    public long getItemCount(ItemStack stack) {
        for (IMonitoredValue value : this.getList()) {
            if (!(value instanceof ItemCount)) continue;
            ItemCount count = (ItemCount)value;
            if (!count.item.getStoredStack().equalStack(stack)) continue;
            return count.item.getStored();
        }
        return 0L;
    }
}

