/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.fluids;

import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.IJoinableInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValueInfo;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;
import sonar.logistics.core.tiles.displays.info.types.fluids.ElementNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidCount;

@ASMInfo(id="fluid", modid="practicallogistics2")
public class InfoNetworkFluid
extends BaseInfo<InfoNetworkFluid>
implements IJoinableInfo<InfoNetworkFluid>,
INameableInfo<InfoNetworkFluid>,
IComparableInfo<InfoNetworkFluid>,
IMonitoredValueInfo<InfoNetworkFluid> {
    public static final String id = "fluid";
    public SyncNBTAbstract<StoredFluidStack> fluidStack = new SyncNBTAbstract(StoredFluidStack.class, 0);
    public final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(1).setDefault((Object)-1);

    public InfoNetworkFluid() {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
    }

    public InfoNetworkFluid(StoredFluidStack stack) {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
        this.fluidStack.setObject((INBTSyncable)stack);
    }

    public InfoNetworkFluid(StoredFluidStack stack, int networkID) {
        this.syncList.addParts(new IDirtyPart[]{this.fluidStack, this.networkID});
        this.fluidStack.setObject((INBTSyncable)stack);
        this.networkID.setObject((Object)networkID);
    }

    @Override
    public boolean isIdenticalInfo(InfoNetworkFluid info) {
        return this.getStoredStack().equals((Object)info.getStoredStack()) && ((Integer)this.networkID.getObject()).equals(info.networkID.getObject());
    }

    @Override
    public boolean isMatchingInfo(InfoNetworkFluid info) {
        return this.getStoredStack().equalStack(info.getFluidStack());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof InfoNetworkFluid;
    }

    @Override
    public boolean canJoinInfo(InfoNetworkFluid info) {
        return this.isMatchingInfo(info);
    }

    @Override
    public IJoinableInfo joinInfo(InfoNetworkFluid info) {
        ((StoredFluidStack)this.fluidStack.getObject()).add((StoredFluidStack)info.fluidStack.getObject());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.fluidStack.getObject() != null && ((StoredFluidStack)this.fluidStack.getObject()).fluid != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public InfoNetworkFluid copy() {
        return new InfoNetworkFluid(((StoredFluidStack)this.fluidStack.getObject()).copy(), (Integer)this.networkID.getObject());
    }

    @Override
    public String getClientIdentifier() {
        return this.fluidStack.getObject() != null && ((StoredFluidStack)this.fluidStack.getObject()).fluid != null ? ((StoredFluidStack)this.fluidStack.getObject()).fluid.getLocalizedName() : "FLUIDSTACK";
    }

    @Override
    public String getClientObject() {
        return this.fluidStack.getObject() != null ? "" + FontHelper.formatFluidSize((long)((StoredFluidStack)this.fluidStack.getObject()).stored) : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    @Override
    public void createDefaultElements(List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        super.createDefaultElements(toAdd, h, uuid);
        toAdd.add(new ElementNetworkFluid(uuid));
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        StoredFluidStack stack = (StoredFluidStack)this.fluidStack.getObject();
        objects.add(new ComparableObject(this, "Stored", stack.stored));
        objects.add(new ComparableObject(this, "Capacity", stack.capacity));
        return objects;
    }

    public String toString() {
        return ((StoredFluidStack)this.fluidStack.getObject()).toString();
    }

    public FluidStack getFluidStack() {
        return ((StoredFluidStack)this.fluidStack.getObject()).getFullStack();
    }

    public StoredFluidStack getStoredStack() {
        return (StoredFluidStack)this.fluidStack.getObject();
    }

    public long getStored() {
        return ((StoredFluidStack)this.fluidStack.getObject()).stored;
    }

    public int getNetworkSource() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public IMonitoredValue<InfoNetworkFluid> createMonitoredValue() {
        return new FluidCount(this);
    }
}

