/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.modes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import sonar.core.api.utils.BlockInteractionType;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.modes.GSIElementSelection;
import sonar.logistics.core.tiles.displays.gsi.modes.IGSIMode;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GSISelectionMode
implements IGSIMode {
    public DisplayGSI gsi;
    public GSIElementSelection selectionType;
    public List<Integer> selected_identities = new ArrayList<Integer>();

    public GSISelectionMode(DisplayGSI gsi) {
        this.gsi = gsi;
    }

    public void startElementSelectionMode(GSIElementSelection type) {
        this.selectionType = type;
        this.selected_identities = new ArrayList<Integer>();
        this.gsi.mode = this.gsi.selection_mode;
    }

    public void onElementSelected(int containerID, BlockInteractionType type) {
        if (type == BlockInteractionType.RIGHT) {
            if (this.selected_identities.contains(containerID)) {
                this.selected_identities.remove((Object)containerID);
            } else {
                this.selected_identities.add(containerID);
            }
        }
        if (type == BlockInteractionType.SHIFT_LEFT) {
            this.finishElementSelectionMode(false);
        }
        if (type == BlockInteractionType.SHIFT_RIGHT && !this.selected_identities.isEmpty()) {
            this.finishElementSelectionMode(true);
        }
    }

    public void finishElementSelectionMode(boolean sendPacket) {
        if (sendPacket) {
            this.selectionType.finishSelection(this.gsi, this.selected_identities);
        }
        this.selectionType = null;
        this.selected_identities = new ArrayList<Integer>();
        this.gsi.mode = this.gsi.default_mode;
    }

    @Override
    public boolean onClicked(TileAbstractDisplay part, BlockPos pos, DisplayScreenClick click, BlockInteractionType type, EntityPlayer player) {
        for (DisplayElementContainer container : this.gsi.containers.values()) {
            if (this.gsi.isEditContainer(container) || !container.canRender() || !container.canClickContainer(click.clickX, click.clickY)) continue;
            this.gsi.selection_mode.onElementSelected(container.getContainerIdentity(), type);
            break;
        }
        return true;
    }

    @Override
    public void renderMode() {
    }

    @Override
    public boolean renderElements() {
        return true;
    }

    @Override
    public boolean renderEditContainer() {
        return true;
    }
}

